/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.hc.client5.http.HttpRequestRetryHandler;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.Methods;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultHttpRequestRetryHandler
implements HttpRequestRetryHandler {
    public static final DefaultHttpRequestRetryHandler INSTANCE = new DefaultHttpRequestRetryHandler();
    private final int retryCount;
    private final Set<Class<? extends IOException>> nonRetriableClasses;

    @SafeVarargs
    protected DefaultHttpRequestRetryHandler(int retryCount, Class<? extends IOException> ... clazzes) {
        this.retryCount = retryCount;
        this.nonRetriableClasses = new HashSet<Class<? extends IOException>>();
        this.nonRetriableClasses.addAll(Arrays.asList(clazzes));
    }

    public DefaultHttpRequestRetryHandler(int retryCount) {
        this(retryCount, InterruptedIOException.class, UnknownHostException.class, ConnectException.class, ConnectionClosedException.class, SSLException.class);
    }

    public DefaultHttpRequestRetryHandler() {
        this(3);
    }

    @Override
    public boolean retryRequest(HttpRequest request, IOException exception, int executionCount, HttpContext context) {
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)exception, (String)"I/O exception");
        if (executionCount > this.retryCount) {
            return false;
        }
        if (this.nonRetriableClasses.contains(exception.getClass())) {
            return false;
        }
        for (Class<? extends IOException> rejectException : this.nonRetriableClasses) {
            if (!rejectException.isInstance(exception)) continue;
            return false;
        }
        if (request instanceof CancellableDependency && ((CancellableDependency)request).isCancelled()) {
            return false;
        }
        return this.handleAsIdempotent(request);
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    protected boolean handleAsIdempotent(HttpRequest request) {
        return Methods.isIdempotent((String)request.getMethod());
    }
}

