/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.testing.classic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.MethodNotSupportedException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.http.protocol.HttpContext;

public class RandomHandler
implements HttpRequestHandler {
    public void handle(ClassicHttpRequest request, ClassicHttpResponse response, HttpContext context) throws HttpException, IOException {
        long n;
        URI uri;
        String method = request.getMethod();
        if (!("GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method) || "POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method))) {
            throw new MethodNotSupportedException(method + " not supported by " + this.getClass().getName());
        }
        try {
            uri = request.getUri();
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException(ex.getMessage(), (Throwable)ex);
        }
        String path = uri.getPath();
        int slash = path.lastIndexOf(47);
        if (slash != -1) {
            String payload = path.substring(slash + 1, path.length());
            if (!payload.isEmpty()) {
                try {
                    n = Long.parseLong(payload);
                }
                catch (NumberFormatException ex) {
                    throw new ProtocolException("Invalid request path: " + path);
                }
            } else {
                n = 1 + (int)(Math.random() * 79.0);
            }
        } else {
            throw new ProtocolException("Invalid request path: " + path);
        }
        response.setCode(200);
        response.setEntity((HttpEntity)new RandomEntity(n));
    }

    public static class RandomEntity
    extends AbstractHttpEntity {
        private static final byte[] RANGE = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".getBytes(StandardCharsets.US_ASCII);
        protected final long length;

        public RandomEntity(long len) {
            this.length = len;
        }

        public final boolean isStreaming() {
            return false;
        }

        public boolean isRepeatable() {
            return true;
        }

        public long getContentLength() {
            return this.length;
        }

        public InputStream getContent() {
            throw new UnsupportedOperationException();
        }

        public void writeTo(OutputStream out) throws IOException {
            int end;
            int remaining;
            int blocksize = 2048;
            byte[] data = new byte[Math.min(remaining, 2048)];
            for (remaining = (int)this.length; remaining > 0; remaining -= end) {
                end = Math.min(remaining, data.length);
                double value = 0.0;
                for (int i = 0; i < end; ++i) {
                    if (i % 5 == 0) {
                        value = Math.random();
                    }
                    int d = (int)(value *= (double)RANGE.length);
                    value -= (double)d;
                    data[i] = RANGE[d];
                }
                out.write(data, 0, end);
                out.flush();
            }
            out.close();
        }

        public void close() throws IOException {
        }
    }
}

