/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.ssl;

import java.net.SocketAddress;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.apache.hc.client5.http.ssl.HttpsSupport;
import org.apache.hc.client5.http.ssl.TlsSessionValidator;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.ssl.H2TlsSupport;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
abstract class AbstractClientTlsStrategy
implements TlsStrategy {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final SSLContext sslContext;
    private final String[] supportedProtocols;
    private final String[] supportedCipherSuites;
    private final SSLBufferMode sslBufferManagement;
    private final HostnameVerifier hostnameVerifier;
    private final TlsSessionValidator tlsSessionValidator;

    AbstractClientTlsStrategy(SSLContext sslContext, String[] supportedProtocols, String[] supportedCipherSuites, SSLBufferMode sslBufferManagement, HostnameVerifier hostnameVerifier) {
        this.sslContext = (SSLContext)Args.notNull((Object)sslContext, (String)"SSL context");
        this.supportedProtocols = supportedProtocols;
        this.supportedCipherSuites = supportedCipherSuites;
        this.sslBufferManagement = sslBufferManagement != null ? sslBufferManagement : SSLBufferMode.STATIC;
        this.hostnameVerifier = hostnameVerifier != null ? hostnameVerifier : HttpsSupport.getDefaultHostnameVerifier();
        this.tlsSessionValidator = new TlsSessionValidator(this.log);
    }

    public boolean upgrade(TransportSecurityLayer tlsSession, final HttpHost host, SocketAddress localAddress, SocketAddress remoteAddress, final Object attachment) {
        tlsSession.startTls(this.sslContext, (NamedEndpoint)host, this.sslBufferManagement, new SSLSessionInitializer(){

            public void initialize(NamedEndpoint endpoint, SSLEngine sslEngine) {
                HttpVersionPolicy versionPolicy = attachment instanceof HttpVersionPolicy ? (HttpVersionPolicy)attachment : HttpVersionPolicy.NEGOTIATE;
                SSLParameters sslParameters = sslEngine.getSSLParameters();
                if (AbstractClientTlsStrategy.this.supportedProtocols != null) {
                    sslParameters.setProtocols(AbstractClientTlsStrategy.this.supportedProtocols);
                } else if (versionPolicy != HttpVersionPolicy.FORCE_HTTP_1) {
                    sslParameters.setProtocols(H2TlsSupport.excludeBlacklistedProtocols((String[])sslParameters.getProtocols()));
                }
                if (AbstractClientTlsStrategy.this.supportedCipherSuites != null) {
                    sslParameters.setCipherSuites(AbstractClientTlsStrategy.this.supportedCipherSuites);
                } else if (versionPolicy != HttpVersionPolicy.FORCE_HTTP_1) {
                    sslParameters.setCipherSuites(H2TlsSupport.excludeBlacklistedCiphers((String[])sslParameters.getCipherSuites()));
                }
                if (versionPolicy != HttpVersionPolicy.FORCE_HTTP_1) {
                    H2TlsSupport.setEnableRetransmissions((SSLParameters)sslParameters, (boolean)false);
                }
                AbstractClientTlsStrategy.this.applyParameters(sslEngine, sslParameters, H2TlsSupport.selectApplicationProtocols((Object)attachment));
                AbstractClientTlsStrategy.this.initializeEngine(sslEngine);
                if (AbstractClientTlsStrategy.this.log.isDebugEnabled()) {
                    AbstractClientTlsStrategy.this.log.debug("Enabled protocols: " + Arrays.asList(sslEngine.getEnabledProtocols()));
                    AbstractClientTlsStrategy.this.log.debug("Enabled cipher suites:" + Arrays.asList(sslEngine.getEnabledCipherSuites()));
                }
            }
        }, new SSLSessionVerifier(){

            public TlsDetails verify(NamedEndpoint endpoint, SSLEngine sslEngine) throws SSLException {
                AbstractClientTlsStrategy.this.verifySession(host.getHostName(), sslEngine.getSession());
                return AbstractClientTlsStrategy.this.createTlsDetails(sslEngine);
            }
        });
        return true;
    }

    abstract void applyParameters(SSLEngine var1, SSLParameters var2, String[] var3);

    abstract TlsDetails createTlsDetails(SSLEngine var1);

    protected void initializeEngine(SSLEngine sslEngine) {
    }

    protected void verifySession(String hostname, SSLSession sslsession) throws SSLException {
        this.tlsSessionValidator.verifySession(hostname, sslsession, this.hostnameVerifier);
    }
}

