/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.IOSessionListener;
import org.apache.hc.core5.testing.classic.LoggingSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingIOSessionListener
implements IOSessionListener {
    public static final LoggingIOSessionListener INSTANCE = new LoggingIOSessionListener();
    private final Logger connLog = LoggerFactory.getLogger((String)"org.apache.hc.core5.http.connection");

    private LoggingIOSessionListener() {
    }

    public void tlsStarted(IOSession session) {
        if (this.connLog.isDebugEnabled()) {
            this.connLog.debug(LoggingSupport.getId(session) + " TLS session started: " + session);
        }
    }

    public void tlsInbound(IOSession session) {
        if (this.connLog.isDebugEnabled()) {
            this.connLog.debug(LoggingSupport.getId(session) + " TLS inbound: " + session);
        }
    }

    public void tlsOutbound(IOSession session) {
        if (this.connLog.isDebugEnabled()) {
            this.connLog.debug(LoggingSupport.getId(session) + " TLS outbound: " + session);
        }
    }

    public void connected(IOSession session) {
        if (this.connLog.isDebugEnabled()) {
            this.connLog.debug(LoggingSupport.getId(session) + " connected: " + session);
        }
    }

    public void inputReady(IOSession session) {
        if (this.connLog.isDebugEnabled()) {
            this.connLog.debug(LoggingSupport.getId(session) + " input ready: " + session);
        }
    }

    public void outputReady(IOSession session) {
        if (this.connLog.isDebugEnabled()) {
            this.connLog.debug(LoggingSupport.getId(session) + " output ready: " + session);
        }
    }

    public void timeout(IOSession session) {
        if (this.connLog.isDebugEnabled()) {
            this.connLog.debug(LoggingSupport.getId(session) + " timeout: " + session);
        }
    }

    public void exception(IOSession session, Exception ex) {
        if (ex instanceof ConnectionClosedException) {
            return;
        }
        this.connLog.error(LoggingSupport.getId(session) + " " + ex.getMessage(), (Throwable)ex);
    }

    public void disconnected(IOSession session) {
        if (this.connLog.isDebugEnabled()) {
            this.connLog.debug(LoggingSupport.getId(session) + " disconnected: " + session);
        }
    }
}

