/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncRequestConsumer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;

public class BasicRequestConsumer<T>
implements AsyncRequestConsumer<Message<HttpRequest, T>> {
    private final AsyncEntityConsumer<T> dataConsumer;
    private volatile Message<HttpRequest, T> result;

    public BasicRequestConsumer(AsyncEntityConsumer<T> dataConsumer) {
        this.dataConsumer = dataConsumer;
    }

    @Override
    public void consumeRequest(final HttpRequest request, EntityDetails entityDetails, HttpContext httpContext, final FutureCallback<Message<HttpRequest, T>> resultCallback) throws HttpException, IOException {
        Args.notNull(request, "Request");
        if (entityDetails != null) {
            Asserts.notNull(this.dataConsumer, "Data consumer");
            this.dataConsumer.streamStart(entityDetails, new FutureCallback<T>(){

                @Override
                public void completed(T body) {
                    BasicRequestConsumer.this.result = new Message(request, body);
                    if (resultCallback != null) {
                        resultCallback.completed(BasicRequestConsumer.this.result);
                    }
                    BasicRequestConsumer.this.dataConsumer.releaseResources();
                }

                @Override
                public void failed(Exception ex) {
                    if (resultCallback != null) {
                        resultCallback.failed(ex);
                    }
                    BasicRequestConsumer.this.dataConsumer.releaseResources();
                }

                @Override
                public void cancelled() {
                    if (resultCallback != null) {
                        resultCallback.cancelled();
                    }
                    BasicRequestConsumer.this.dataConsumer.releaseResources();
                }
            });
        } else {
            this.result = new Message<HttpRequest, Object>(request, null);
            if (resultCallback != null) {
                resultCallback.completed(this.result);
            }
            this.releaseResources();
        }
    }

    @Override
    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        Asserts.notNull(this.dataConsumer, "Data consumer");
        this.dataConsumer.updateCapacity(capacityChannel);
    }

    @Override
    public void consume(ByteBuffer src) throws IOException {
        Asserts.notNull(this.dataConsumer, "Data consumer");
        this.dataConsumer.consume(src);
    }

    @Override
    public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        Asserts.notNull(this.dataConsumer, "Data consumer");
        this.dataConsumer.streamEnd(trailers);
    }

    @Override
    public void failed(Exception cause) {
        this.releaseResources();
    }

    @Override
    public Message<HttpRequest, T> getResult() {
        return this.result;
    }

    @Override
    public void releaseResources() {
        if (this.dataConsumer != null) {
            this.dataConsumer.releaseResources();
        }
    }
}

