/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.osgi.impl;

import java.util.List;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.osgi.impl.OSGiCredentialsProvider;
import org.apache.hc.client5.http.osgi.impl.OSGiHttpRoutePlanner;
import org.apache.hc.client5.http.osgi.impl.RelaxedLayeredConnectionSocketFactory;
import org.apache.hc.client5.http.osgi.services.ProxyConfiguration;
import org.apache.hc.client5.http.osgi.services.TrustedHostsConfiguration;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;

final class HttpClientBuilderConfigurator {
    private final OSGiCredentialsProvider credentialsProvider;
    private final OSGiHttpRoutePlanner routePlanner;
    private final Registry<ConnectionSocketFactory> socketFactoryRegistry;

    HttpClientBuilderConfigurator(List<ProxyConfiguration> proxyConfigurations, TrustedHostsConfiguration trustedHostsConfiguration) {
        this.credentialsProvider = new OSGiCredentialsProvider(proxyConfigurations);
        this.routePlanner = new OSGiHttpRoutePlanner(proxyConfigurations);
        this.socketFactoryRegistry = this.createSocketFactoryRegistry(trustedHostsConfiguration);
    }

    <T extends HttpClientBuilder> T configure(T clientBuilder) {
        clientBuilder.setDefaultCredentialsProvider(this.credentialsProvider).setRoutePlanner(this.routePlanner).setConnectionManager(new PoolingHttpClientConnectionManager(this.socketFactoryRegistry));
        return clientBuilder;
    }

    private Registry<ConnectionSocketFactory> createSocketFactoryRegistry(TrustedHostsConfiguration trustedHostsConfiguration) {
        return RegistryBuilder.create().register(URIScheme.HTTP.id, (Object)PlainConnectionSocketFactory.INSTANCE).register(URIScheme.HTTPS.id, (Object)this.createSocketFactory(trustedHostsConfiguration)).build();
    }

    private ConnectionSocketFactory createSocketFactory(TrustedHostsConfiguration trustedHostsConfiguration) {
        return new RelaxedLayeredConnectionSocketFactory(trustedHostsConfiguration, SSLConnectionSocketFactory.getSocketFactory());
    }
}

