/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.Iterator;
import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.MessageSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CacheableRequestPolicy {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    CacheableRequestPolicy() {
    }

    public boolean isServableFromCache(HttpRequest request) {
        HttpVersion pv;
        String method = request.getMethod();
        Object object = pv = request.getVersion() != null ? request.getVersion() : HttpVersion.DEFAULT;
        if (HttpVersion.HTTP_1_1.compareToVersion((ProtocolVersion)pv) != 0) {
            this.log.debug("non-HTTP/1.1 request is not serveable from cache");
            return false;
        }
        if (!method.equals("GET") && !method.equals("HEAD")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(method + " request is not serveable from cache");
            }
            return false;
        }
        if (request.countHeaders("Pragma") > 0) {
            this.log.debug("request with Pragma header is not serveable from cache");
            return false;
        }
        Iterator it = MessageSupport.iterate((MessageHeaders)request, (String)"Cache-Control");
        while (it.hasNext()) {
            HeaderElement cacheControlElement = (HeaderElement)it.next();
            if ("no-store".equalsIgnoreCase(cacheControlElement.getName())) {
                this.log.debug("Request with no-store is not serveable from cache");
                return false;
            }
            if (!"no-cache".equalsIgnoreCase(cacheControlElement.getName())) continue;
            this.log.debug("Request with no-cache is not serveable from cache");
            return false;
        }
        this.log.debug("Request is serveable from cache");
        return true;
    }
}

