/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.classic.methods;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.hc.client5.http.StandardMethods;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.Configurable;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.message.HeaderGroup;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.util.Args;

public class RequestBuilder {
    private String method;
    private Charset charset;
    private ProtocolVersion version;
    private URI uri;
    private HeaderGroup headerGroup;
    private HttpEntity entity;
    private List<NameValuePair> parameters;
    private RequestConfig config;

    RequestBuilder(String method) {
        this.charset = StandardCharsets.UTF_8;
        this.method = method;
    }

    RequestBuilder() {
    }

    RequestBuilder(StandardMethods method) {
        this(method.name());
    }

    RequestBuilder(String method, URI uri) {
        this.method = method;
        this.uri = uri;
    }

    RequestBuilder(StandardMethods method, URI uri) {
        this(method.name(), uri);
    }

    RequestBuilder(String method, String uri) {
        this.method = method;
        this.uri = uri != null ? URI.create(uri) : null;
    }

    RequestBuilder(StandardMethods method, String uri) {
        this(method.name(), uri);
    }

    public static RequestBuilder create(String method) {
        Args.notBlank((CharSequence)method, (String)"HTTP method");
        return new RequestBuilder(method);
    }

    public static RequestBuilder get() {
        return new RequestBuilder(StandardMethods.GET.name());
    }

    public static RequestBuilder get(URI uri) {
        return new RequestBuilder(StandardMethods.GET, uri);
    }

    public static RequestBuilder get(String uri) {
        return new RequestBuilder(StandardMethods.GET, uri);
    }

    public static RequestBuilder head() {
        return new RequestBuilder(StandardMethods.HEAD);
    }

    public static RequestBuilder head(URI uri) {
        return new RequestBuilder(StandardMethods.HEAD, uri);
    }

    public static RequestBuilder head(String uri) {
        return new RequestBuilder(StandardMethods.HEAD, uri);
    }

    public static RequestBuilder patch() {
        return new RequestBuilder(StandardMethods.PATCH.name());
    }

    public static RequestBuilder patch(URI uri) {
        return new RequestBuilder(StandardMethods.PATCH, uri);
    }

    public static RequestBuilder patch(String uri) {
        return new RequestBuilder(StandardMethods.PATCH, uri);
    }

    public static RequestBuilder post() {
        return new RequestBuilder(StandardMethods.POST);
    }

    public static RequestBuilder post(URI uri) {
        return new RequestBuilder(StandardMethods.POST, uri);
    }

    public static RequestBuilder post(String uri) {
        return new RequestBuilder(StandardMethods.POST, uri);
    }

    public static RequestBuilder put() {
        return new RequestBuilder(StandardMethods.PUT);
    }

    public static RequestBuilder put(URI uri) {
        return new RequestBuilder(StandardMethods.PUT, uri);
    }

    public static RequestBuilder put(String uri) {
        return new RequestBuilder(StandardMethods.PUT, uri);
    }

    public static RequestBuilder delete() {
        return new RequestBuilder(StandardMethods.DELETE);
    }

    public static RequestBuilder delete(URI uri) {
        return new RequestBuilder(StandardMethods.DELETE, uri);
    }

    public static RequestBuilder delete(String uri) {
        return new RequestBuilder(StandardMethods.DELETE, uri);
    }

    public static RequestBuilder trace() {
        return new RequestBuilder(StandardMethods.TRACE);
    }

    public static RequestBuilder trace(URI uri) {
        return new RequestBuilder(StandardMethods.TRACE, uri);
    }

    public static RequestBuilder trace(String uri) {
        return new RequestBuilder(StandardMethods.TRACE, uri);
    }

    public static RequestBuilder options() {
        return new RequestBuilder(StandardMethods.OPTIONS);
    }

    public static RequestBuilder options(URI uri) {
        return new RequestBuilder(StandardMethods.OPTIONS, uri);
    }

    public static RequestBuilder options(String uri) {
        return new RequestBuilder(StandardMethods.OPTIONS, uri);
    }

    public static RequestBuilder copy(ClassicHttpRequest request) {
        Args.notNull((Object)request, (String)"HTTP request");
        return new RequestBuilder().doCopy(request);
    }

    private RequestBuilder doCopy(ClassicHttpRequest request) {
        if (request == null) {
            return this;
        }
        this.method = request.getMethod();
        this.version = request.getVersion();
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.clear();
        this.headerGroup.setHeaders(request.getHeaders());
        this.parameters = null;
        this.entity = null;
        HttpEntity originalEntity = request.getEntity();
        ContentType contentType = EntityUtils.getContentType((HttpEntity)originalEntity);
        if (contentType != null && contentType.getMimeType().equals(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
            try {
                List formParams = EntityUtils.parse((HttpEntity)originalEntity);
                if (!formParams.isEmpty()) {
                    this.parameters = formParams;
                }
            }
            catch (IOException ignore) {}
        } else {
            this.entity = originalEntity;
        }
        try {
            this.uri = request.getUri();
        }
        catch (URISyntaxException ignore) {
            // empty catch block
        }
        this.config = request instanceof Configurable ? ((Configurable)request).getConfig() : null;
        return this;
    }

    public RequestBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getMethod() {
        return this.method;
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public RequestBuilder setVersion(ProtocolVersion version) {
        this.version = version;
        return this;
    }

    public URI getUri() {
        return this.uri;
    }

    public RequestBuilder setUri(URI uri) {
        this.uri = uri;
        return this;
    }

    public RequestBuilder setUri(String uri) {
        this.uri = uri != null ? URI.create(uri) : null;
        return this;
    }

    public Header getFirstHeader(String name) {
        return this.headerGroup != null ? this.headerGroup.getFirstHeader(name) : null;
    }

    public Header getLastHeader(String name) {
        return this.headerGroup != null ? this.headerGroup.getLastHeader(name) : null;
    }

    public Header[] getHeaders(String name) {
        return this.headerGroup != null ? this.headerGroup.getHeaders(name) : null;
    }

    public RequestBuilder addHeader(Header header) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.addHeader(header);
        return this;
    }

    public RequestBuilder addHeader(String name, String value) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.addHeader((Header)new BasicHeader(name, (Object)value));
        return this;
    }

    public RequestBuilder removeHeader(Header header) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.removeHeader(header);
        return this;
    }

    public RequestBuilder removeHeaders(String name) {
        if (name == null || this.headerGroup == null) {
            return this;
        }
        Iterator i = this.headerGroup.headerIterator();
        while (i.hasNext()) {
            Header header = (Header)i.next();
            if (!name.equalsIgnoreCase(header.getName())) continue;
            i.remove();
        }
        return this;
    }

    public RequestBuilder setHeader(Header header) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.setHeader(header);
        return this;
    }

    public RequestBuilder setHeader(String name, String value) {
        if (this.headerGroup == null) {
            this.headerGroup = new HeaderGroup();
        }
        this.headerGroup.setHeader((Header)new BasicHeader(name, (Object)value));
        return this;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public RequestBuilder setEntity(HttpEntity entity) {
        this.entity = entity;
        return this;
    }

    public List<NameValuePair> getParameters() {
        return this.parameters != null ? new ArrayList<NameValuePair>(this.parameters) : new ArrayList();
    }

    public RequestBuilder addParameter(NameValuePair nvp) {
        Args.notNull((Object)nvp, (String)"Name value pair");
        if (this.parameters == null) {
            this.parameters = new LinkedList<NameValuePair>();
        }
        this.parameters.add(nvp);
        return this;
    }

    public RequestBuilder addParameter(String name, String value) {
        return this.addParameter((NameValuePair)new BasicNameValuePair(name, value));
    }

    public RequestBuilder addParameters(NameValuePair ... nvps) {
        for (NameValuePair nvp : nvps) {
            this.addParameter(nvp);
        }
        return this;
    }

    public RequestConfig getConfig() {
        return this.config;
    }

    public RequestBuilder setConfig(RequestConfig config) {
        this.config = config;
        return this;
    }

    public ClassicHttpRequest build() {
        URI uriNotNull = this.uri != null ? this.uri : URI.create("/");
        Object entityCopy = this.entity;
        if (this.parameters != null && !this.parameters.isEmpty()) {
            if (entityCopy == null && (StandardMethods.POST.name().equalsIgnoreCase(this.method) || StandardMethods.PUT.name().equalsIgnoreCase(this.method))) {
                entityCopy = new UrlEncodedFormEntity(this.parameters, this.charset != null ? this.charset : StandardCharsets.ISO_8859_1);
            } else {
                try {
                    uriNotNull = new URIBuilder(uriNotNull).setCharset(this.charset).addParameters(this.parameters).build();
                }
                catch (URISyntaxException ex) {
                    // empty catch block
                }
            }
        }
        HttpUriRequestBase result = new HttpUriRequestBase(this.method, uriNotNull);
        result.setVersion((ProtocolVersion)(this.version != null ? this.version : HttpVersion.HTTP_1_1));
        if (this.headerGroup != null) {
            result.setHeaders(this.headerGroup.getHeaders());
        }
        result.setEntity((HttpEntity)entityCopy);
        result.setConfig(this.config);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RequestBuilder [method=");
        builder.append(this.method);
        builder.append(", charset=");
        builder.append(this.charset);
        builder.append(", version=");
        builder.append(this.version);
        builder.append(", uri=");
        builder.append(this.uri);
        builder.append(", headerGroup=");
        builder.append(this.headerGroup);
        builder.append(", entity=");
        builder.append(this.entity);
        builder.append(", parameters=");
        builder.append(this.parameters);
        builder.append(", config=");
        builder.append(this.config);
        builder.append("]");
        return builder.toString();
    }
}

