/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.impl.BasicHttpConnectionMetrics;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.nio.command.ExecutableCommand;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http2.H2ConnectionException;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.frame.DefaultFrameFactory;
import org.apache.hc.core5.http2.frame.FrameFactory;
import org.apache.hc.core5.http2.frame.StreamIdGenerator;
import org.apache.hc.core5.http2.impl.nio.AbstractHttp2StreamMultiplexer;
import org.apache.hc.core5.http2.impl.nio.Http2StreamChannel;
import org.apache.hc.core5.http2.impl.nio.Http2StreamHandler;
import org.apache.hc.core5.http2.impl.nio.Http2StreamListener;
import org.apache.hc.core5.http2.impl.nio.ServerHttp2StreamHandler;
import org.apache.hc.core5.net.InetAddressUtils;
import org.apache.hc.core5.reactor.ProtocolIOSession;
import org.apache.hc.core5.util.Args;

@Internal
public class ServerHttp2StreamMultiplexer
extends AbstractHttp2StreamMultiplexer {
    private final HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory;

    public ServerHttp2StreamMultiplexer(ProtocolIOSession ioSession, FrameFactory frameFactory, HttpProcessor httpProcessor, HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory, CharCodingConfig charCodingConfig, H2Config h2Config, Http2StreamListener streamListener) {
        super(ioSession, frameFactory, StreamIdGenerator.EVEN, httpProcessor, charCodingConfig, h2Config, streamListener);
        this.exchangeHandlerFactory = (HandlerFactory)Args.notNull(exchangeHandlerFactory, (String)"Handler factory");
    }

    public ServerHttp2StreamMultiplexer(ProtocolIOSession ioSession, HttpProcessor httpProcessor, HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory, CharCodingConfig charCodingConfig, H2Config h2Config) {
        this(ioSession, DefaultFrameFactory.INSTANCE, httpProcessor, exchangeHandlerFactory, charCodingConfig, h2Config, null);
    }

    @Override
    void acceptHeaderFrame() throws H2ConnectionException {
    }

    @Override
    void acceptPushRequest() throws H2ConnectionException {
    }

    @Override
    void acceptPushFrame() throws H2ConnectionException {
        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Push not supported");
    }

    @Override
    Http2StreamHandler createRemotelyInitiatedStream(Http2StreamChannel channel, HttpProcessor httpProcessor, BasicHttpConnectionMetrics connMetrics, HandlerFactory<AsyncPushConsumer> pushHandlerFactory) throws IOException {
        HttpCoreContext context = HttpCoreContext.create();
        context.setAttribute("http.ssl-session", (Object)this.getSSLSession());
        context.setAttribute("http.connection-endpoint", (Object)this.getEndpointDetails());
        return new ServerHttp2StreamHandler(channel, httpProcessor, connMetrics, this.exchangeHandlerFactory, context);
    }

    @Override
    Http2StreamHandler createLocallyInitiatedStream(ExecutableCommand command, Http2StreamChannel channel, HttpProcessor httpProcessor, BasicHttpConnectionMetrics connMetrics) throws IOException {
        throw new H2ConnectionException(H2Error.INTERNAL_ERROR, "Illegal attempt to execute a request");
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        InetAddressUtils.formatAddress((StringBuilder)buffer, (SocketAddress)this.getRemoteAddress());
        buffer.append("->");
        InetAddressUtils.formatAddress((StringBuilder)buffer, (SocketAddress)this.getLocalAddress());
        return buffer.toString();
    }
}

