/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import java.io.IOException;
import org.apache.hc.client5.http.RouteInfo;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestAuthCache
implements HttpRequestInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        AuthScheme authScheme;
        AuthExchange proxyAuthExchange;
        HttpHost proxy;
        AuthScheme authScheme2;
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)context, (String)"HTTP context");
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        AuthCache authCache = clientContext.getAuthCache();
        if (authCache == null) {
            this.log.debug("Auth cache not set in the context");
            return;
        }
        CredentialsProvider credsProvider = clientContext.getCredentialsProvider();
        if (credsProvider == null) {
            this.log.debug("Credentials provider not set in the context");
            return;
        }
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            this.log.debug("Route info not set in the context");
            return;
        }
        URIAuthority authority = request.getAuthority();
        HttpHost target = authority != null ? new HttpHost(authority.getHostName(), authority.getPort() >= 0 ? authority.getPort() : route.getTargetHost().getPort(), request.getScheme()) : route.getTargetHost();
        AuthExchange targetAuthExchange = clientContext.getAuthExchange(target);
        if (targetAuthExchange.getState() == AuthExchange.State.UNCHALLENGED && (authScheme2 = authCache.get(target)) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Re-using cached '" + authScheme2.getName() + "' auth scheme for " + target);
            }
            targetAuthExchange.select(authScheme2);
        }
        if ((proxy = route.getProxyHost()) != null && (proxyAuthExchange = clientContext.getAuthExchange(proxy)).getState() == AuthExchange.State.UNCHALLENGED && (authScheme = authCache.get(proxy)) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Re-using cached '" + authScheme.getName() + "' auth scheme for " + proxy);
            }
            proxyAuthExchange.select(authScheme);
        }
    }
}

