/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.nio.ManagedAsyncClientConnection;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.reactor.ssl.SSLBufferManagement;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import org.apache.hc.core5.util.Identifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
final class DefaultManagedAsyncClientConnection
implements ManagedAsyncClientConnection,
Identifiable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final IOSession ioSession;
    private final int socketTimeout;
    private final AtomicBoolean closed;

    public DefaultManagedAsyncClientConnection(IOSession ioSession) {
        this.ioSession = ioSession;
        this.socketTimeout = ioSession.getSocketTimeout();
        this.closed = new AtomicBoolean();
    }

    public String getId() {
        return ConnPoolSupport.getId(this.ioSession);
    }

    public void shutdown(ShutdownType shutdownType) {
        if (this.closed.compareAndSet(false, true)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.getId() + ": Shutdown connection " + shutdownType);
            }
            this.ioSession.shutdown(shutdownType);
        }
    }

    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.getId() + ": Close connection");
            }
            this.ioSession.addFirst((Command)new ShutdownCommand(ShutdownType.GRACEFUL));
        }
    }

    public boolean isOpen() {
        return !this.ioSession.isClosed();
    }

    public void setSocketTimeout(int timeout) {
        this.ioSession.setSocketTimeout(timeout);
    }

    public int getSocketTimeout() {
        return this.ioSession.getSocketTimeout();
    }

    public SocketAddress getRemoteAddress() {
        return this.ioSession.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.ioSession.getLocalAddress();
    }

    public EndpointDetails getEndpointDetails() {
        IOEventHandler handler = this.ioSession.getHandler();
        if (handler instanceof HttpConnection) {
            return ((HttpConnection)handler).getEndpointDetails();
        }
        return null;
    }

    public ProtocolVersion getProtocolVersion() {
        IOEventHandler handler = this.ioSession.getHandler();
        if (handler instanceof HttpConnection) {
            return ((HttpConnection)handler).getProtocolVersion();
        }
        return HttpVersion.DEFAULT;
    }

    public void startTls(SSLContext sslContext, SSLBufferManagement sslBufferManagement, SSLSessionInitializer initializer, SSLSessionVerifier verifier) throws UnsupportedOperationException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.getId() + ": start TLS");
        }
        if (!(this.ioSession instanceof TransportSecurityLayer)) {
            throw new UnsupportedOperationException("TLS upgrade not supported");
        }
        ((TransportSecurityLayer)this.ioSession).startTls(sslContext, sslBufferManagement, initializer, verifier);
    }

    public TlsDetails getTlsDetails() {
        return this.ioSession instanceof TransportSecurityLayer ? ((TransportSecurityLayer)this.ioSession).getTlsDetails() : null;
    }

    public SSLSession getSSLSession() {
        TlsDetails tlsDetails = this.getTlsDetails();
        return tlsDetails != null ? tlsDetails.getSSLSession() : null;
    }

    @Override
    public void submitPriorityCommand(Command command) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.getId() + ": priority command " + command);
        }
        this.ioSession.addFirst(command);
    }

    @Override
    public void submitCommand(Command command) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.getId() + ": command " + command);
        }
        this.ioSession.addLast(command);
    }

    @Override
    public void passivate() {
        this.ioSession.setSocketTimeout(0);
    }

    @Override
    public void activate() {
        this.ioSession.setSocketTimeout(this.socketTimeout);
    }
}

