/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.hc.client5.http.impl.io.LoggingSocketHolder;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentLengthStrategy;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.H1Config;
import org.apache.hc.core5.http.impl.io.DefaultBHttpClientConnection;
import org.apache.hc.core5.http.impl.io.SocketHolder;
import org.apache.hc.core5.http.io.HttpMessageParserFactory;
import org.apache.hc.core5.http.io.HttpMessageWriterFactory;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.util.Identifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultManagedHttpClientConnection
extends DefaultBHttpClientConnection
implements ManagedHttpClientConnection,
Identifiable {
    private final Logger log = LoggerFactory.getLogger(DefaultManagedHttpClientConnection.class);
    private final Logger headerlog = LoggerFactory.getLogger((String)"org.apache.hc.client5.http.headers");
    private final Logger wirelog = LoggerFactory.getLogger((String)"org.apache.hc.client5.http.wire");
    private final String id;
    private final AtomicBoolean closed;
    private int socketTimeout;

    public DefaultManagedHttpClientConnection(String id, CharsetDecoder chardecoder, CharsetEncoder charencoder, H1Config h1Config, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, HttpMessageWriterFactory<ClassicHttpRequest> requestWriterFactory, HttpMessageParserFactory<ClassicHttpResponse> responseParserFactory) {
        super(h1Config, chardecoder, charencoder, incomingContentStrategy, outgoingContentStrategy, requestWriterFactory, responseParserFactory);
        this.id = id;
        this.closed = new AtomicBoolean();
    }

    public DefaultManagedHttpClientConnection(String id) {
        this(id, null, null, null, null, null, null, null);
    }

    public String getId() {
        return this.id;
    }

    public void bind(SocketHolder socketHolder) throws IOException {
        if (this.closed.get()) {
            Socket socket = socketHolder.getSocket();
            socket.close();
            throw new InterruptedIOException("Connection already shutdown");
        }
        super.bind(socketHolder);
        this.socketTimeout = socketHolder.getSocket().getSoTimeout();
    }

    @Override
    public Socket getSocket() {
        SocketHolder socketHolder = this.getSocketHolder();
        return socketHolder != null ? socketHolder.getSocket() : null;
    }

    @Override
    public SSLSession getSSLSession() {
        Socket socket = this.getSocket();
        if (socket instanceof SSLSocket) {
            return ((SSLSocket)socket).getSession();
        }
        return null;
    }

    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.id + ": Close connection");
            }
            super.close();
        }
    }

    public void setSocketTimeout(int timeout) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + ": set socket timeout to " + timeout);
        }
        super.setSocketTimeout(timeout);
    }

    public void shutdown(ShutdownType shutdownType) {
        if (this.closed.compareAndSet(false, true)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(this.id + ": Shutdown connection " + shutdownType);
            }
            super.shutdown(shutdownType);
        }
    }

    @Override
    public void bind(Socket socket) throws IOException {
        super.bind((SocketHolder)(this.wirelog.isDebugEnabled() ? new LoggingSocketHolder(socket, this.id, this.wirelog) : new SocketHolder(socket)));
        this.socketTimeout = socket.getSoTimeout();
    }

    protected void onResponseReceived(ClassicHttpResponse response) {
        if (response != null && this.headerlog.isDebugEnabled()) {
            Header[] headers;
            this.headerlog.debug(this.id + " << " + new StatusLine((HttpResponse)response));
            for (Header header : headers = response.getAllHeaders()) {
                this.headerlog.debug(this.id + " << " + header.toString());
            }
        }
    }

    protected void onRequestSubmitted(ClassicHttpRequest request) {
        if (request != null && this.headerlog.isDebugEnabled()) {
            Header[] headers;
            this.headerlog.debug(this.id + " >> " + new RequestLine((HttpRequest)request));
            for (Header header : headers = request.getAllHeaders()) {
                this.headerlog.debug(this.id + " >> " + header.toString());
            }
        }
    }

    @Override
    public void passivate() {
        super.setSocketTimeout(0);
    }

    @Override
    public void activate() {
        super.setSocketTimeout(this.socketTimeout);
    }
}

