/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.InterruptedIOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.async.AsyncExecRuntime;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.Operations;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.concurrent.ComplexCancellable;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.command.ExecutionCommand;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http2.nio.pool.H2ConnPool;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;

class InternalHttp2AsyncExecRuntime
implements AsyncExecRuntime {
    private final Logger log;
    private final H2ConnPool connPool;
    private final AtomicReference<Endpoint> sessionRef;
    private volatile boolean reusable;

    InternalHttp2AsyncExecRuntime(Logger log, H2ConnPool connPool) {
        this.log = log;
        this.connPool = connPool;
        this.sessionRef = new AtomicReference<Object>(null);
    }

    @Override
    public boolean isConnectionAcquired() {
        return this.sessionRef.get() != null;
    }

    @Override
    public Cancellable acquireConnection(HttpRoute route, Object object, HttpClientContext context, final FutureCallback<AsyncExecRuntime> callback) {
        if (this.sessionRef.get() == null) {
            final HttpHost target = route.getTargetHost();
            RequestConfig requestConfig = context.getRequestConfig();
            return Operations.cancellable(this.connPool.getSession((Object)target, requestConfig.getConnectionTimeout(), (FutureCallback)new FutureCallback<IOSession>(){

                public void completed(IOSession ioSession) {
                    InternalHttp2AsyncExecRuntime.this.sessionRef.set(new Endpoint(target, ioSession));
                    InternalHttp2AsyncExecRuntime.this.reusable = true;
                    callback.completed((Object)InternalHttp2AsyncExecRuntime.this);
                }

                public void failed(Exception ex) {
                    callback.failed(ex);
                }

                public void cancelled() {
                    callback.cancelled();
                }
            }));
        }
        callback.completed((Object)this);
        return Operations.nonCancellable();
    }

    @Override
    public void releaseConnection() {
        Endpoint endpoint = this.sessionRef.getAndSet(null);
        if (endpoint != null && !this.reusable) {
            endpoint.session.shutdown(ShutdownType.GRACEFUL);
        }
    }

    @Override
    public void discardConnection() {
        Endpoint endpoint = this.sessionRef.getAndSet(null);
        if (endpoint != null) {
            endpoint.session.shutdown(ShutdownType.GRACEFUL);
        }
    }

    @Override
    public boolean validateConnection() {
        if (this.reusable) {
            Endpoint endpoint = this.sessionRef.get();
            return endpoint != null && !endpoint.session.isClosed();
        }
        Endpoint endpoint = this.sessionRef.getAndSet(null);
        if (endpoint != null) {
            endpoint.session.shutdown(ShutdownType.GRACEFUL);
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        Endpoint endpoint = this.sessionRef.get();
        return endpoint != null && !endpoint.session.isClosed();
    }

    Endpoint ensureValid() {
        Endpoint endpoint = this.sessionRef.get();
        if (endpoint == null) {
            throw new IllegalStateException("I/O session not acquired / already released");
        }
        return endpoint;
    }

    @Override
    public Cancellable connect(HttpClientContext context, final FutureCallback<AsyncExecRuntime> callback) {
        Endpoint endpoint = this.ensureValid();
        if (!endpoint.session.isClosed()) {
            callback.completed((Object)this);
            return Operations.nonCancellable();
        }
        final HttpHost target = endpoint.target;
        RequestConfig requestConfig = context.getRequestConfig();
        return Operations.cancellable(this.connPool.getSession((Object)target, requestConfig.getConnectionTimeout(), (FutureCallback)new FutureCallback<IOSession>(){

            public void completed(IOSession ioSession) {
                InternalHttp2AsyncExecRuntime.this.sessionRef.set(new Endpoint(target, ioSession));
                InternalHttp2AsyncExecRuntime.this.reusable = true;
                callback.completed((Object)InternalHttp2AsyncExecRuntime.this);
            }

            public void failed(Exception ex) {
                callback.failed(ex);
            }

            public void cancelled() {
                callback.cancelled();
            }
        }));
    }

    @Override
    public void upgradeTls(HttpClientContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cancellable execute(final AsyncClientExchangeHandler exchangeHandler, final HttpClientContext context) {
        final ComplexCancellable complexCancellable = new ComplexCancellable();
        final Endpoint endpoint = this.ensureValid();
        final IOSession session = endpoint.session;
        if (!session.isClosed()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(ConnPoolSupport.getId(endpoint) + ": executing " + ConnPoolSupport.getId(exchangeHandler));
            }
            session.addLast((Command)new ExecutionCommand(exchangeHandler, (CancellableDependency)complexCancellable, (HttpContext)context));
        } else {
            final HttpHost target = endpoint.target;
            RequestConfig requestConfig = context.getRequestConfig();
            this.connPool.getSession((Object)target, requestConfig.getConnectionTimeout(), (FutureCallback)new FutureCallback<IOSession>(){

                public void completed(IOSession ioSession) {
                    InternalHttp2AsyncExecRuntime.this.sessionRef.set(new Endpoint(target, ioSession));
                    InternalHttp2AsyncExecRuntime.this.reusable = true;
                    if (InternalHttp2AsyncExecRuntime.this.log.isDebugEnabled()) {
                        InternalHttp2AsyncExecRuntime.this.log.debug(ConnPoolSupport.getId(endpoint) + ": executing " + ConnPoolSupport.getId(exchangeHandler));
                    }
                    session.addLast((Command)new ExecutionCommand(exchangeHandler, (CancellableDependency)complexCancellable, (HttpContext)context));
                }

                public void failed(Exception ex) {
                    exchangeHandler.failed(ex);
                }

                public void cancelled() {
                    exchangeHandler.failed((Exception)new InterruptedIOException());
                }
            });
        }
        return complexCancellable;
    }

    @Override
    public void markConnectionReusable(Object newState, TimeValue newValidDuration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void markConnectionNonReusable() {
        this.reusable = false;
    }

    @Override
    public AsyncExecRuntime fork() {
        return new InternalHttp2AsyncExecRuntime(this.log, this.connPool);
    }

    static class Endpoint {
        final HttpHost target;
        final IOSession session;

        Endpoint(HttpHost target, IOSession session) {
            this.target = target;
            this.session = session;
        }
    }
}

