/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.util.List;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.async.LogAppendable;
import org.apache.hc.client5.http.impl.async.LoggingIOSession;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.frame.FramePrinter;
import org.apache.hc.core5.http2.frame.RawFrame;
import org.apache.hc.core5.http2.impl.nio.ClientHttp2StreamMultiplexerFactory;
import org.apache.hc.core5.http2.impl.nio.Http2OnlyClientProtocolNegotiator;
import org.apache.hc.core5.http2.impl.nio.Http2StreamListener;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.TlsCapableIOSession;
import org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
class Http2AsyncClientEventHandlerFactory
implements IOEventHandlerFactory {
    private final Logger wireLog = LoggerFactory.getLogger((String)"org.apache.hc.client5.http.wire");
    private final Logger headerLog = LoggerFactory.getLogger((String)"org.apache.hc.client5.http.headers");
    private final Logger frameLog = LoggerFactory.getLogger((String)"org.apache.hc.client5.http2.frame");
    private final Logger framePayloadLog = LoggerFactory.getLogger((String)"org.apache.hc.client5.http2.frame.payload");
    private final Logger flowCtrlLog = LoggerFactory.getLogger((String)"org.apache.hc.client5.http2.flow");
    private final HttpProcessor httpProcessor;
    private final HandlerFactory<AsyncPushConsumer> exchangeHandlerFactory;
    private final H2Config h2Config;
    private final CharCodingConfig charCodingConfig;

    Http2AsyncClientEventHandlerFactory(HttpProcessor httpProcessor, HandlerFactory<AsyncPushConsumer> exchangeHandlerFactory, H2Config h2Config, CharCodingConfig charCodingConfig) {
        this.httpProcessor = (HttpProcessor)Args.notNull((Object)httpProcessor, (String)"HTTP processor");
        this.exchangeHandlerFactory = exchangeHandlerFactory;
        this.h2Config = h2Config != null ? h2Config : H2Config.DEFAULT;
        this.charCodingConfig = charCodingConfig != null ? charCodingConfig : CharCodingConfig.DEFAULT;
    }

    public IOEventHandler createHandler(TlsCapableIOSession ioSession, Object attachment) {
        Logger sessionLog = LoggerFactory.getLogger(ioSession.getClass());
        if (sessionLog.isDebugEnabled() || this.wireLog.isDebugEnabled() || this.headerLog.isDebugEnabled() || this.frameLog.isDebugEnabled() || this.framePayloadLog.isDebugEnabled() || this.flowCtrlLog.isDebugEnabled()) {
            final String id = ConnPoolSupport.getId(ioSession);
            ClientHttp2StreamMultiplexerFactory http2StreamHandlerFactory = new ClientHttp2StreamMultiplexerFactory(this.httpProcessor, this.exchangeHandlerFactory, this.h2Config, this.charCodingConfig, new Http2StreamListener(){
                final FramePrinter framePrinter = new FramePrinter();

                private void logFrameInfo(String prefix, RawFrame frame) {
                    try {
                        LogAppendable logAppendable = new LogAppendable(Http2AsyncClientEventHandlerFactory.this.frameLog, prefix);
                        this.framePrinter.printFrameInfo(frame, (Appendable)logAppendable);
                        logAppendable.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }

                private void logFramePayload(String prefix, RawFrame frame) {
                    try {
                        LogAppendable logAppendable = new LogAppendable(Http2AsyncClientEventHandlerFactory.this.framePayloadLog, prefix);
                        this.framePrinter.printPayload(frame, (Appendable)logAppendable);
                        logAppendable.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }

                private void logFlowControl(String prefix, int streamId, int delta, int actualSize) {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append(prefix).append(" stream ").append(streamId).append(" flow control ").append(delta).append(" -> ").append(actualSize);
                    Http2AsyncClientEventHandlerFactory.this.flowCtrlLog.debug(buffer.toString());
                }

                public void onHeaderInput(HttpConnection connection, int streamId, List<? extends Header> headers) {
                    if (Http2AsyncClientEventHandlerFactory.this.headerLog.isDebugEnabled()) {
                        for (int i = 0; i < headers.size(); ++i) {
                            Http2AsyncClientEventHandlerFactory.this.headerLog.debug(id + " << " + headers.get(i));
                        }
                    }
                }

                public void onHeaderOutput(HttpConnection connection, int streamId, List<? extends Header> headers) {
                    if (Http2AsyncClientEventHandlerFactory.this.headerLog.isDebugEnabled()) {
                        for (int i = 0; i < headers.size(); ++i) {
                            Http2AsyncClientEventHandlerFactory.this.headerLog.debug(id + " >> " + headers.get(i));
                        }
                    }
                }

                public void onFrameInput(HttpConnection connection, int streamId, RawFrame frame) {
                    if (Http2AsyncClientEventHandlerFactory.this.frameLog.isDebugEnabled()) {
                        this.logFrameInfo(id + " <<", frame);
                    }
                    if (Http2AsyncClientEventHandlerFactory.this.framePayloadLog.isDebugEnabled()) {
                        this.logFramePayload(id + " <<", frame);
                    }
                }

                public void onFrameOutput(HttpConnection connection, int streamId, RawFrame frame) {
                    if (Http2AsyncClientEventHandlerFactory.this.frameLog.isDebugEnabled()) {
                        this.logFrameInfo(id + " >>", frame);
                    }
                    if (Http2AsyncClientEventHandlerFactory.this.framePayloadLog.isDebugEnabled()) {
                        this.logFramePayload(id + " >>", frame);
                    }
                }

                public void onInputFlowControl(HttpConnection connection, int streamId, int delta, int actualSize) {
                    if (Http2AsyncClientEventHandlerFactory.this.flowCtrlLog.isDebugEnabled()) {
                        this.logFlowControl(id + " <<", streamId, delta, actualSize);
                    }
                }

                public void onOutputFlowControl(HttpConnection connection, int streamId, int delta, int actualSize) {
                    if (Http2AsyncClientEventHandlerFactory.this.flowCtrlLog.isDebugEnabled()) {
                        this.logFlowControl(id + " >>", streamId, delta, actualSize);
                    }
                }
            });
            LoggingIOSession loggingIOSession = new LoggingIOSession(ioSession, id, sessionLog, this.wireLog);
            return new Http2OnlyClientProtocolNegotiator((TlsCapableIOSession)loggingIOSession, http2StreamHandlerFactory, false);
        }
        ClientHttp2StreamMultiplexerFactory http2StreamHandlerFactory = new ClientHttp2StreamMultiplexerFactory(this.httpProcessor, this.exchangeHandlerFactory, this.h2Config, this.charCodingConfig, null);
        return new Http2OnlyClientProtocolNegotiator(ioSession, http2StreamHandlerFactory, false);
    }
}

