/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.async.HttpAsyncClient;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestProducer;
import org.apache.hc.client5.http.async.methods.SimpleResponseConsumer;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.reactor.ExceptionEvent;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

@Contract(threading=ThreadingBehavior.SAFE)
public abstract class CloseableHttpAsyncClient
implements HttpAsyncClient,
Closeable {
    public abstract void start();

    public abstract IOReactorStatus getStatus();

    public abstract List<ExceptionEvent> getExceptionLog();

    public abstract void awaitShutdown(TimeValue var1) throws InterruptedException;

    public abstract void initiateShutdown();

    public abstract void shutdown(ShutdownType var1);

    public final <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback) {
        return this.execute(requestProducer, responseConsumer, (HttpContext)HttpClientContext.create(), callback);
    }

    public final void register(String uriPattern, Supplier<AsyncPushConsumer> supplier) {
        this.register(null, uriPattern, supplier);
    }

    public final Future<SimpleHttpResponse> execute(SimpleHttpRequest request, HttpContext context, FutureCallback<SimpleHttpResponse> callback) {
        Args.notNull((Object)request, (String)"Request");
        final BasicFuture future = new BasicFuture(callback);
        this.execute((AsyncRequestProducer)SimpleRequestProducer.create(request), SimpleResponseConsumer.create(), context, new FutureCallback<SimpleHttpResponse>(){

            public void completed(SimpleHttpResponse response) {
                future.completed((Object)response);
            }

            public void failed(Exception ex) {
                future.failed(ex);
            }

            public void cancelled() {
                future.cancel(true);
            }
        });
        return future;
    }

    public final Future<SimpleHttpResponse> execute(SimpleHttpRequest request, FutureCallback<SimpleHttpResponse> callback) {
        return this.execute(request, (HttpContext)HttpClientContext.create(), callback);
    }
}

