/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.cache;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.HeaderGroup;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class HttpCacheEntry
implements MessageHeaders,
Serializable {
    private static final long serialVersionUID = -6300496422359477413L;
    private static final String REQUEST_METHOD_HEADER_NAME = "Hc-Request-Method";
    private final Date requestDate;
    private final Date responseDate;
    private final int status;
    private final HeaderGroup responseHeaders;
    private final Resource resource;
    private final Map<String, String> variantMap;
    private final Date date;

    public HttpCacheEntry(Date requestDate, Date responseDate, int status, Header[] responseHeaders, Resource resource, Map<String, String> variantMap) {
        Args.notNull((Object)requestDate, (String)"Request date");
        Args.notNull((Object)responseDate, (String)"Response date");
        Args.check((status >= 200 ? 1 : 0) != 0, (String)"Status code");
        Args.notNull((Object)responseHeaders, (String)"Response headers");
        this.requestDate = requestDate;
        this.responseDate = responseDate;
        this.status = status;
        this.responseHeaders = new HeaderGroup();
        this.responseHeaders.setHeaders(responseHeaders);
        this.resource = resource;
        this.variantMap = variantMap != null ? new HashMap<String, String>(variantMap) : null;
        this.date = this.parseDate();
    }

    public HttpCacheEntry(Date requestDate, Date responseDate, int status, Header[] responseHeaders, Resource resource) {
        this(requestDate, responseDate, status, responseHeaders, resource, new HashMap<String, String>());
    }

    private Date parseDate() {
        return DateUtils.parseDate(this, "Date");
    }

    public int getStatus() {
        return this.status;
    }

    public Date getRequestDate() {
        return this.requestDate;
    }

    public Date getResponseDate() {
        return this.responseDate;
    }

    public Header[] getAllHeaders() {
        HeaderGroup filteredHeaders = new HeaderGroup();
        Iterator iterator = this.responseHeaders.headerIterator();
        while (iterator.hasNext()) {
            Header header = (Header)iterator.next();
            if (REQUEST_METHOD_HEADER_NAME.equals(header.getName())) continue;
            filteredHeaders.addHeader(header);
        }
        return filteredHeaders.getAllHeaders();
    }

    public Header getFirstHeader(String name) {
        if (REQUEST_METHOD_HEADER_NAME.equalsIgnoreCase(name)) {
            return null;
        }
        return this.responseHeaders.getFirstHeader(name);
    }

    public Header getLastHeader(String name) {
        return this.responseHeaders.getLastHeader(name);
    }

    public Header[] getHeaders(String name) {
        if (REQUEST_METHOD_HEADER_NAME.equalsIgnoreCase(name)) {
            return new Header[0];
        }
        return this.responseHeaders.getHeaders(name);
    }

    public boolean containsHeader(String name) {
        return this.responseHeaders.containsHeader(name);
    }

    public int containsHeaders(String name) {
        return this.responseHeaders.containsHeaders(name);
    }

    public Header getSingleHeader(String name) throws ProtocolException {
        return this.responseHeaders.getSingleHeader(name);
    }

    public Iterator<Header> headerIterator() {
        return this.responseHeaders.headerIterator();
    }

    public Iterator<Header> headerIterator(String name) {
        return this.responseHeaders.headerIterator(name);
    }

    public Date getDate() {
        return this.date;
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean hasVariants() {
        return this.getFirstHeader("Vary") != null;
    }

    public Map<String, String> getVariantMap() {
        return Collections.unmodifiableMap(this.variantMap);
    }

    public String getRequestMethod() {
        Header requestMethodHeader = this.responseHeaders.getFirstHeader(REQUEST_METHOD_HEADER_NAME);
        if (requestMethodHeader != null) {
            return requestMethodHeader.getValue();
        }
        return "GET";
    }

    public String toString() {
        return "[request date=" + this.requestDate + "; response date=" + this.responseDate + "; status=" + this.status + "]";
    }
}

