/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.H1Config;
import org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import org.apache.hc.core5.http.impl.HttpProcessors;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.testing.nio.AsyncRequester;
import org.apache.hc.core5.testing.nio.ClientSessionEndpoint;
import org.apache.hc.core5.testing.nio.InternalClientHttp1EventHandlerFactory;
import org.apache.hc.core5.util.TimeValue;

public class Http1TestClient
extends AsyncRequester {
    private final SSLContext sslContext;

    public Http1TestClient(IOReactorConfig ioReactorConfig, SSLContext sslContext) throws IOException {
        super(ioReactorConfig);
        this.sslContext = sslContext;
    }

    public Http1TestClient() throws IOException {
        this(IOReactorConfig.DEFAULT, (SSLContext)null);
    }

    public void start(HttpProcessor httpProcessor, H1Config h1Config) throws IOException {
        this.execute(new InternalClientHttp1EventHandlerFactory(httpProcessor, h1Config, CharCodingConfig.DEFAULT, (ConnectionReuseStrategy)DefaultConnectionReuseStrategy.INSTANCE, this.sslContext));
    }

    public void start(H1Config h1Config) throws IOException {
        this.start(HttpProcessors.client(), h1Config);
    }

    public void start() throws IOException {
        this.start(H1Config.DEFAULT);
    }

    public Future<ClientSessionEndpoint> connect(HttpHost host, TimeValue timeout, FutureCallback<ClientSessionEndpoint> callback) throws InterruptedException {
        final BasicFuture future = new BasicFuture(callback);
        this.requestSession(host, timeout, new FutureCallback<IOSession>(){

            public void completed(IOSession session) {
                future.completed((Object)new ClientSessionEndpoint(session));
            }

            public void failed(Exception cause) {
                future.failed(cause);
            }

            public void cancelled() {
                future.cancel();
            }
        });
        return future;
    }

    public Future<ClientSessionEndpoint> connect(HttpHost host, TimeValue timeout) throws InterruptedException {
        return this.connect(host, timeout, null);
    }

    public Future<ClientSessionEndpoint> connect(String hostname, int port, TimeValue timeout) throws InterruptedException {
        return this.connect(new HttpHost(hostname, port), timeout, null);
    }
}

