/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.cache;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.util.Args;

public final class HttpCacheResponse
implements EntityDetails {
    private final int code;
    private final String reasonPhrase;
    private final byte[] body;
    private final ContentType contentType;

    public static HttpCacheResponse create(int code, String reasonPhrase, byte[] body, ContentType contentType) {
        return new HttpCacheResponse(code, reasonPhrase, body, contentType);
    }

    public static HttpCacheResponse create(int code, byte[] body, ContentType contentType) {
        return new HttpCacheResponse(code, null, body, contentType);
    }

    public static HttpCacheResponse create(int code, String reasonPhrase) {
        return new HttpCacheResponse(code, reasonPhrase, null, null);
    }

    public static HttpCacheResponse create(int code) {
        return new HttpCacheResponse(code, null, null, null);
    }

    public static HttpCacheResponse create(int code, String reasonPhrase, String body, ContentType contentType) {
        if (body != null) {
            Charset charset = contentType != null ? contentType.getCharset() : null;
            byte[] b = body.getBytes(charset != null ? charset : StandardCharsets.US_ASCII);
            return new HttpCacheResponse(code, reasonPhrase, b, contentType);
        }
        return HttpCacheResponse.create(code, reasonPhrase);
    }

    public static HttpCacheResponse create(int code, String body, ContentType contentType) {
        return HttpCacheResponse.create(code, null, body, contentType);
    }

    private HttpCacheResponse(int code, String reasonPhrase, byte[] body, ContentType contentType) {
        this.code = Args.checkRange((int)code, (int)200, (int)599, (String)"HTTP status");
        this.reasonPhrase = reasonPhrase;
        this.body = body;
        this.contentType = contentType;
    }

    public int getCode() {
        return this.code;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public byte[] getBody() {
        return this.body;
    }

    public long getContentLength() {
        return this.body != null ? (long)this.body.length : 0L;
    }

    public String getContentType() {
        return this.contentType != null ? this.contentType.toString() : null;
    }

    public String getContentEncoding() {
        return null;
    }

    public boolean isChunked() {
        return false;
    }

    public Set<String> getTrailerNames() {
        return null;
    }
}

