/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.cache;

import java.util.Collection;
import java.util.Map;
import org.apache.hc.client5.http.cache.HttpAsyncCacheStorage;
import org.apache.hc.client5.http.cache.HttpCacheCASOperation;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.HttpCacheStorage;
import org.apache.hc.client5.http.impl.Operations;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.util.Args;

public final class HttpAsyncCacheStorageAdaptor
implements HttpAsyncCacheStorage {
    private final HttpCacheStorage cacheStorage;

    public HttpAsyncCacheStorageAdaptor(HttpCacheStorage cacheStorage) {
        this.cacheStorage = (HttpCacheStorage)Args.notNull((Object)cacheStorage, (String)"Cache strorage");
    }

    @Override
    public Cancellable putEntry(String key, HttpCacheEntry entry, FutureCallback<Boolean> callback) {
        Args.notEmpty((CharSequence)key, (String)"Key");
        Args.notNull((Object)entry, (String)"Cache ehtry");
        Args.notNull(callback, (String)"Callback");
        try {
            this.cacheStorage.putEntry(key, entry);
            callback.completed((Object)Boolean.TRUE);
        }
        catch (Exception ex) {
            callback.failed(ex);
        }
        return Operations.nonCancellable();
    }

    @Override
    public Cancellable getEntry(String key, FutureCallback<HttpCacheEntry> callback) {
        Args.notEmpty((CharSequence)key, (String)"Key");
        Args.notNull(callback, (String)"Callback");
        try {
            HttpCacheEntry entry = this.cacheStorage.getEntry(key);
            callback.completed((Object)entry);
        }
        catch (Exception ex) {
            callback.failed(ex);
        }
        return Operations.nonCancellable();
    }

    @Override
    public Cancellable removeEntry(String key, FutureCallback<Boolean> callback) {
        Args.notEmpty((CharSequence)key, (String)"Key");
        Args.notNull(callback, (String)"Callback");
        try {
            this.cacheStorage.removeEntry(key);
            callback.completed((Object)Boolean.TRUE);
        }
        catch (Exception ex) {
            callback.failed(ex);
        }
        return Operations.nonCancellable();
    }

    @Override
    public Cancellable updateEntry(String key, HttpCacheCASOperation casOperation, FutureCallback<Boolean> callback) {
        Args.notEmpty((CharSequence)key, (String)"Key");
        Args.notNull((Object)casOperation, (String)"CAS operation");
        Args.notNull(callback, (String)"Callback");
        try {
            this.cacheStorage.updateEntry(key, casOperation);
            callback.completed((Object)Boolean.TRUE);
        }
        catch (Exception ex) {
            callback.failed(ex);
        }
        return Operations.nonCancellable();
    }

    @Override
    public Cancellable getEntries(Collection<String> keys, FutureCallback<Map<String, HttpCacheEntry>> callback) {
        Args.notNull(keys, (String)"Key");
        Args.notNull(callback, (String)"Callback");
        try {
            callback.completed(this.cacheStorage.getEntries(keys));
        }
        catch (Exception ex) {
            callback.failed(ex);
        }
        return Operations.nonCancellable();
    }
}

