/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;

public final class FileEntityProducer
implements AsyncEntityProducer {
    private final File file;
    private final ByteBuffer bytebuf;
    private final long length;
    private final ContentType contentType;
    private final AtomicReference<Exception> exception;
    private AtomicReference<RandomAccessFile> accessFileRef;
    private boolean eof;

    public FileEntityProducer(File file, int bufferSize, ContentType contentType) {
        this.file = Args.notNull(file, "File");
        this.length = file.length();
        this.bytebuf = ByteBuffer.allocate((int)((long)bufferSize > this.length ? (long)bufferSize : this.length));
        this.contentType = contentType;
        this.accessFileRef = new AtomicReference<Object>(null);
        this.exception = new AtomicReference<Object>(null);
    }

    public FileEntityProducer(File file, ContentType contentType) {
        this(file, 8192, contentType);
    }

    public FileEntityProducer(File content) {
        this(content, ContentType.APPLICATION_OCTET_STREAM);
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public String getContentType() {
        return this.contentType != null ? this.contentType.toString() : null;
    }

    @Override
    public long getContentLength() {
        return this.length;
    }

    @Override
    public int available() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public Set<String> getTrailerNames() {
        return null;
    }

    @Override
    public void produce(DataStreamChannel channel) throws IOException {
        int bytesRead;
        RandomAccessFile accessFile = this.accessFileRef.get();
        if (accessFile == null) {
            accessFile = new RandomAccessFile(this.file, "r");
            Asserts.check(this.accessFileRef.getAndSet(accessFile) == null, "Illegal producer state");
        }
        if (!this.eof && (bytesRead = accessFile.getChannel().read(this.bytebuf)) < 0) {
            this.eof = true;
        }
        if (this.bytebuf.position() > 0) {
            this.bytebuf.flip();
            channel.write(this.bytebuf);
            this.bytebuf.compact();
        }
        if (this.eof && this.bytebuf.position() == 0) {
            channel.endStream();
            this.releaseResources();
        }
    }

    @Override
    public void failed(Exception cause) {
        if (this.exception.compareAndSet(null, cause)) {
            this.releaseResources();
        }
    }

    public Exception getException() {
        return this.exception.get();
    }

    @Override
    public void releaseResources() {
        this.eof = false;
        RandomAccessFile accessFile = this.accessFileRef.getAndSet(null);
        if (accessFile != null) {
            try {
                accessFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

