/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.config.Configurable;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.ExecSupport;
import org.apache.hc.client5.http.impl.async.AbstractMinimalHttpAsyncClientBase;
import org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import org.apache.hc.client5.http.impl.async.LoggingAsyncClientExchangeHandler;
import org.apache.hc.client5.http.impl.classic.RequestFailedException;
import org.apache.hc.client5.http.impl.nio.MultuhomeConnectionInitiator;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.concurrent.ComplexFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.hc.core5.http.nio.command.ExecutionCommand;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http2.nio.pool.H2ConnPool;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Timeout;

public final class MinimalHttp2AsyncClient
extends AbstractMinimalHttpAsyncClientBase {
    private final H2ConnPool connPool;
    private final ConnectionInitiator connectionInitiator;

    MinimalHttp2AsyncClient(IOEventHandlerFactory eventHandlerFactory, AsyncPushConsumerRegistry pushConsumerRegistry, IOReactorConfig reactorConfig, ThreadFactory threadFactory, ThreadFactory workerThreadFactory, DnsResolver dnsResolver, TlsStrategy tlsStrategy) {
        super(new DefaultConnectingIOReactor(eventHandlerFactory, reactorConfig, workerThreadFactory, null, null, (Callback)new Callback<IOSession>(){

            public void execute(IOSession ioSession) {
                ioSession.addFirst((Command)new ShutdownCommand(ShutdownType.GRACEFUL));
            }
        }), pushConsumerRegistry, threadFactory);
        this.connectionInitiator = new MultuhomeConnectionInitiator(this.getConnectionInitiator(), dnsResolver);
        this.connPool = new H2ConnPool(this.connectionInitiator, (Resolver)new Resolver<HttpHost, InetSocketAddress>(){

            public InetSocketAddress resolve(HttpHost object) {
                return null;
            }
        }, tlsStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T> void execute(final AsyncClientExchangeHandler exchangeHandler, HttpContext context, final ComplexFuture<T> resultFuture, final Supplier<T> resultSupplier) {
        this.ensureRunning();
        final HttpClientContext clientContext = HttpClientContext.adapt(context);
        try {
            exchangeHandler.produceRequest(new RequestChannel(){

                public void sendRequest(final HttpRequest request, final EntityDetails entityDetails) throws HttpException, IOException {
                    RequestConfig requestConfig = null;
                    if (request instanceof Configurable) {
                        requestConfig = ((Configurable)request).getConfig();
                    }
                    if (requestConfig != null) {
                        clientContext.setRequestConfig(requestConfig);
                    } else {
                        requestConfig = clientContext.getRequestConfig();
                    }
                    Timeout connectTimeout = requestConfig.getConnectionTimeout();
                    HttpHost target = new HttpHost((NamedEndpoint)request.getAuthority(), request.getScheme());
                    Future sessionFuture = MinimalHttp2AsyncClient.this.connPool.getSession((Object)target, connectTimeout, (FutureCallback)new FutureCallback<IOSession>(){

                        public void completed(IOSession session) {
                            AsyncClientExchangeHandler internalExchangeHandler = new AsyncClientExchangeHandler(){

                                public void releaseResources() {
                                    exchangeHandler.releaseResources();
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void failed(Exception cause) {
                                    try {
                                        exchangeHandler.failed(cause);
                                    }
                                    finally {
                                        resultFuture.failed(cause);
                                    }
                                }

                                public void cancel() {
                                    this.failed(new RequestFailedException("Request aborted"));
                                }

                                public void produceRequest(RequestChannel channel) throws HttpException, IOException {
                                    channel.sendRequest(request, entityDetails);
                                }

                                public int available() {
                                    return exchangeHandler.available();
                                }

                                public void produce(DataStreamChannel channel) throws IOException {
                                    exchangeHandler.produce(channel);
                                }

                                public void consumeInformation(HttpResponse response) throws HttpException, IOException {
                                    exchangeHandler.consumeInformation(response);
                                }

                                public void consumeResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                                    exchangeHandler.consumeResponse(response, entityDetails);
                                    if (entityDetails == null) {
                                        resultFuture.completed(resultSupplier.get());
                                    }
                                }

                                public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
                                    exchangeHandler.updateCapacity(capacityChannel);
                                }

                                public int consume(ByteBuffer src) throws IOException {
                                    return exchangeHandler.consume(src);
                                }

                                public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
                                    exchangeHandler.streamEnd(trailers);
                                    resultFuture.completed(resultSupplier.get());
                                }
                            };
                            if (MinimalHttp2AsyncClient.this.log.isDebugEnabled()) {
                                String exchangeId = ExecSupport.getNextExchangeId();
                                MinimalHttp2AsyncClient.this.log.debug(ConnPoolSupport.getId(session) + ": executing message exchange " + exchangeId);
                                session.addLast((Command)new ExecutionCommand((AsyncClientExchangeHandler)new LoggingAsyncClientExchangeHandler(MinimalHttp2AsyncClient.this.log, exchangeId, internalExchangeHandler), (CancellableDependency)resultFuture, (HttpContext)clientContext));
                            } else {
                                session.addLast((Command)new ExecutionCommand(internalExchangeHandler, (CancellableDependency)resultFuture, (HttpContext)clientContext));
                            }
                        }

                        public void failed(Exception ex) {
                            exchangeHandler.failed(ex);
                        }

                        public void cancelled() {
                            exchangeHandler.cancel();
                        }
                    });
                    if (resultFuture != null) {
                        resultFuture.setDependency(sessionFuture);
                    }
                }
            });
        }
        catch (IOException | HttpException ex) {
            try {
                exchangeHandler.failed((Exception)ex);
            }
            finally {
                resultFuture.failed((Exception)ex);
            }
        }
    }
}

