/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.hc.core5.util.Identifiable;
import org.slf4j.Logger;

final class LoggingAsyncClientExchangeHandler
implements AsyncClientExchangeHandler,
Identifiable {
    private final Logger log;
    private final String exchangeId;
    private final AsyncClientExchangeHandler handler;

    LoggingAsyncClientExchangeHandler(Logger log, String exchangeId, AsyncClientExchangeHandler handler) {
        this.log = log;
        this.exchangeId = exchangeId;
        this.handler = handler;
    }

    public String getId() {
        return this.exchangeId;
    }

    public void releaseResources() {
        this.handler.releaseResources();
    }

    public void produceRequest(final RequestChannel channel) throws HttpException, IOException {
        this.handler.produceRequest(new RequestChannel(){

            public void sendRequest(HttpRequest request, EntityDetails entityDetails) throws HttpException, IOException {
                if (LoggingAsyncClientExchangeHandler.this.log.isDebugEnabled()) {
                    LoggingAsyncClientExchangeHandler.this.log.debug(LoggingAsyncClientExchangeHandler.this.exchangeId + ": send request " + new RequestLine(request) + ", " + (entityDetails != null ? "entity len " + entityDetails.getContentLength() : "null entity"));
                }
                channel.sendRequest(request, entityDetails);
            }
        });
    }

    public int available() {
        return this.handler.available();
    }

    public void produce(final DataStreamChannel channel) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.exchangeId + ": produce request data");
        }
        this.handler.produce(new DataStreamChannel(){

            public void requestOutput() {
                channel.requestOutput();
            }

            public int write(ByteBuffer src) throws IOException {
                if (LoggingAsyncClientExchangeHandler.this.log.isDebugEnabled()) {
                    LoggingAsyncClientExchangeHandler.this.log.debug(LoggingAsyncClientExchangeHandler.this.exchangeId + ": produce request data, len " + src.remaining() + " bytes");
                }
                return channel.write((Buffer)src);
            }

            public void endStream() throws IOException {
                if (LoggingAsyncClientExchangeHandler.this.log.isDebugEnabled()) {
                    LoggingAsyncClientExchangeHandler.this.log.debug(LoggingAsyncClientExchangeHandler.this.exchangeId + ": end of request data");
                }
                channel.endStream();
            }

            public void endStream(List<? extends Header> trailers) throws IOException {
                if (LoggingAsyncClientExchangeHandler.this.log.isDebugEnabled()) {
                    LoggingAsyncClientExchangeHandler.this.log.debug(LoggingAsyncClientExchangeHandler.this.exchangeId + ": end of request data");
                }
                channel.endStream(trailers);
            }
        });
    }

    public void consumeInformation(HttpResponse response) throws HttpException, IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.exchangeId + ": information response " + new StatusLine(response));
        }
        this.handler.consumeInformation(response);
    }

    public void consumeResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.exchangeId + ": consume response " + new StatusLine(response) + ", " + (entityDetails != null ? "entity len " + entityDetails.getContentLength() : " null entity"));
        }
        this.handler.consumeResponse(response, entityDetails);
    }

    public void updateCapacity(final CapacityChannel capacityChannel) throws IOException {
        this.handler.updateCapacity(new CapacityChannel(){

            public void update(int increment) throws IOException {
                if (LoggingAsyncClientExchangeHandler.this.log.isDebugEnabled()) {
                    LoggingAsyncClientExchangeHandler.this.log.debug(LoggingAsyncClientExchangeHandler.this.exchangeId + ": capacity update " + increment);
                }
                capacityChannel.update(increment);
            }
        });
    }

    public int consume(ByteBuffer src) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.exchangeId + ": consume response data, len " + src.remaining() + " bytes");
        }
        return this.handler.consume(src);
    }

    public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.exchangeId + ": end of response data");
        }
        this.handler.streamEnd(trailers);
    }

    public void failed(Exception cause) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.exchangeId + ": execution failed: " + cause.getMessage());
        }
        this.handler.failed(cause);
    }

    public void cancel() {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.exchangeId + ": execution cancelled");
        }
        this.handler.cancel();
    }
}

