/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import org.apache.hc.core5.reactor.ExceptionEvent;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractHttpAsyncClientBase
extends CloseableHttpAsyncClient {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AsyncPushConsumerRegistry pushConsumerRegistry;
    private final DefaultConnectingIOReactor ioReactor;
    private final ExecutorService executorService;
    private final AtomicReference<Status> status;

    AbstractHttpAsyncClientBase(DefaultConnectingIOReactor ioReactor, AsyncPushConsumerRegistry pushConsumerRegistry, ThreadFactory threadFactory) {
        this.ioReactor = ioReactor;
        this.pushConsumerRegistry = pushConsumerRegistry;
        this.executorService = Executors.newSingleThreadExecutor(threadFactory);
        this.status = new AtomicReference<Status>(Status.READY);
    }

    @Override
    public final void start() {
        if (this.status.compareAndSet(Status.READY, Status.RUNNING)) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractHttpAsyncClientBase.this.ioReactor.start();
                }
            });
        }
    }

    @Override
    public void register(String hostname, String uriPattern, Supplier<AsyncPushConsumer> supplier) {
        this.pushConsumerRegistry.register(hostname, uriPattern, supplier);
    }

    void ensureRunning() {
        switch (this.status.get()) {
            case READY: {
                throw new IllegalStateException("Client is not running");
            }
            case TERMINATED: {
                throw new IllegalStateException("Client has been terminated");
            }
        }
    }

    ConnectionInitiator getConnectionInitiator() {
        return this.ioReactor;
    }

    @Override
    public final IOReactorStatus getStatus() {
        return this.ioReactor.getStatus();
    }

    @Override
    public final List<ExceptionEvent> getExceptionLog() {
        return this.ioReactor.getExceptionLog();
    }

    @Override
    public final void awaitShutdown(TimeValue waitTime) throws InterruptedException {
        this.ioReactor.awaitShutdown(waitTime);
    }

    @Override
    public final void initiateShutdown() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Initiating shutdown");
        }
        this.ioReactor.initiateShutdown();
    }

    @Override
    public final void shutdown(ShutdownType shutdownType) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Shutdown " + shutdownType);
        }
        this.ioReactor.initiateShutdown();
        this.ioReactor.shutdown(shutdownType);
    }

    @Override
    public void close() {
        this.shutdown(ShutdownType.GRACEFUL);
    }

    static enum Status {
        READY,
        RUNNING,
        TERMINATED;

    }
}

