/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;

public class AuthSupport {
    public static void extractFromAuthority(String scheme, URIAuthority authority, CredentialsStore credentialsStore) {
        char[] password;
        String userName;
        Args.notNull((Object)credentialsStore, (String)"Credentials store");
        if (authority == null) {
            return;
        }
        String userinfo = authority.getUserInfo();
        if (userinfo == null) {
            return;
        }
        int atColon = userinfo.indexOf(58);
        if (atColon >= 0) {
            userName = userinfo.substring(0, atColon);
            password = userinfo.substring(atColon + 1).toCharArray();
        } else {
            userName = userinfo.substring(0, atColon);
            password = null;
        }
        credentialsStore.setCredentials(new AuthScope(scheme, authority.getHostName(), authority.getPort(), null, "Basic"), new UsernamePasswordCredentials(userName, password));
    }

    public static HttpHost resolveAuthTarget(HttpRequest request, HttpRoute route) {
        HttpHost target;
        Args.notNull((Object)request, (String)"Request");
        Args.notNull((Object)route, (String)"Route");
        URIAuthority authority = request.getAuthority();
        String scheme = request.getScheme();
        HttpHost httpHost = target = authority != null ? new HttpHost((NamedEndpoint)authority, scheme) : route.getTargetHost();
        if (target.getPort() < 0) {
            return new HttpHost(target.getHostName(), route.getTargetHost().getPort(), target.getSchemeName());
        }
        return target;
    }
}

