/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.osgi.impl;

import java.util.Arrays;
import java.util.Dictionary;
import org.apache.hc.client5.http.osgi.impl.PropertiesUtils;
import org.apache.hc.client5.http.osgi.services.TrustedHostsConfiguration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

final class OSGiTrustedHostsConfiguration
implements ManagedService,
TrustedHostsConfiguration {
    private static final String PROPERTYNAME_TRUSTEDHOSTS_ENABLED = "trustedhosts.enabled";
    private static final Boolean PROPERTYDEFAULT_TRUSTEDHOSTS_ENABLED = Boolean.TRUE;
    private static final String PROPERTYNAME_TRUST_ALL = "trustedhosts.trustAll";
    private static final Boolean PROPERTYDEFAULT_TRUST_ALL = Boolean.FALSE;
    private static final String PROPERTYNAME_TRUSTED_HOSTS = "trustedhosts.hosts";
    private static final String[] PROPERTYDEFAULT_TRUSTED_HOSTS = new String[]{"localhost", "127.0.0.1"};
    private Boolean enabled = PROPERTYDEFAULT_TRUSTEDHOSTS_ENABLED;
    private Boolean trustAll = PROPERTYDEFAULT_TRUST_ALL;
    private String[] trustedHosts;

    OSGiTrustedHostsConfiguration() {
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean trustAll() {
        return this.trustAll;
    }

    @Override
    public String[] getTrustedHosts() {
        return this.trustedHosts;
    }

    public void updated(Dictionary<String, ?> config) throws ConfigurationException {
        if (config == null) {
            return;
        }
        this.enabled = PropertiesUtils.to(config.get(PROPERTYNAME_TRUSTEDHOSTS_ENABLED), Boolean.TYPE, PROPERTYDEFAULT_TRUSTEDHOSTS_ENABLED);
        this.trustAll = PropertiesUtils.to(config.get(PROPERTYNAME_TRUST_ALL), Boolean.TYPE, PROPERTYDEFAULT_TRUST_ALL);
        this.trustedHosts = PropertiesUtils.to(config.get(PROPERTYNAME_TRUSTED_HOSTS), String[].class, PROPERTYDEFAULT_TRUSTED_HOSTS);
    }

    public String toString() {
        return String.format("ProxyConfiguration [enabled=%s, trustAll=%s, trustedHosts=%s]", this.enabled, this.trustAll, Arrays.asList(this.trustedHosts));
    }
}

