/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.CancellableAware;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.RequestFailedException;
import org.apache.hc.client5.http.io.ConnectionEndpoint;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.io.LeaseRequest;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionRequestTimeoutException;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.apache.logging.log4j.Logger;

class ExecRuntimeImpl
implements ExecRuntime,
Cancellable {
    private final Logger log;
    private final HttpClientConnectionManager manager;
    private final HttpRequestExecutor requestExecutor;
    private final CancellableAware cancellableAware;
    private final AtomicReference<ConnectionEndpoint> endpointRef;
    private volatile boolean reusable;
    private volatile Object state;
    private volatile TimeValue validDuration;

    ExecRuntimeImpl(Logger log, HttpClientConnectionManager manager, HttpRequestExecutor requestExecutor, CancellableAware cancellableAware) {
        this.log = log;
        this.manager = manager;
        this.requestExecutor = requestExecutor;
        this.cancellableAware = cancellableAware;
        this.endpointRef = new AtomicReference<Object>(null);
        this.validDuration = TimeValue.NEG_ONE_MILLISECONDS;
    }

    @Override
    public boolean isExecutionAborted() {
        return this.cancellableAware != null && this.cancellableAware.isCancelled();
    }

    @Override
    public boolean isConnectionAcquired() {
        return this.endpointRef.get() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void acquireConnection(HttpRoute route, Object object, HttpClientContext context) throws IOException {
        Args.notNull((Object)route, (String)"Route");
        if (this.endpointRef.get() != null) throw new IllegalStateException("Endpoint already acquired");
        RequestConfig requestConfig = context.getRequestConfig();
        Timeout requestTimeout = requestConfig.getConnectionRequestTimeout();
        LeaseRequest connRequest = this.manager.lease(route, requestTimeout, object);
        this.state = object;
        if (this.cancellableAware != null) {
            if (this.cancellableAware.isCancelled()) {
                connRequest.cancel();
                throw new RequestFailedException("Request aborted");
            }
            this.cancellableAware.setCancellable(connRequest);
        }
        try {
            ConnectionEndpoint connectionEndpoint = connRequest.get(requestTimeout.getDuration(), requestTimeout.getTimeUnit());
            this.endpointRef.set(connectionEndpoint);
            this.reusable = connectionEndpoint.isConnected();
            if (this.cancellableAware == null) return;
            this.cancellableAware.setCancellable(this);
            return;
        }
        catch (TimeoutException ex) {
            throw new ConnectionRequestTimeoutException(ex.getMessage());
        }
        catch (InterruptedException interrupted) {
            Thread.currentThread().interrupt();
            throw new RequestFailedException("Request aborted", interrupted);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause != null) throw new RequestFailedException("Request execution failed", cause);
            cause = ex;
            throw new RequestFailedException("Request execution failed", cause);
        }
    }

    ConnectionEndpoint ensureValid() {
        ConnectionEndpoint endpoint = this.endpointRef.get();
        if (endpoint == null) {
            throw new IllegalStateException("Endpoint not acquired / already released");
        }
        return endpoint;
    }

    @Override
    public boolean isConnected() {
        ConnectionEndpoint endpoint = this.endpointRef.get();
        return endpoint != null && endpoint.isConnected();
    }

    private void connectEndpoint(ConnectionEndpoint endpoint, HttpClientContext context) throws IOException {
        if (this.cancellableAware != null && this.cancellableAware.isCancelled()) {
            throw new RequestFailedException("Request aborted");
        }
        RequestConfig requestConfig = context.getRequestConfig();
        Timeout timeout = requestConfig.getConnectionTimeout();
        this.manager.connect(endpoint, (TimeValue)timeout, (HttpContext)context);
        if (TimeValue.isPositive((TimeValue)timeout)) {
            endpoint.setSocketTimeout(timeout.toMillisIntBound());
        }
    }

    @Override
    public void connect(HttpClientContext context) throws IOException {
        ConnectionEndpoint endpoint = this.ensureValid();
        if (!endpoint.isConnected()) {
            this.connectEndpoint(endpoint, context);
        }
    }

    @Override
    public void disconnect() throws IOException {
        ConnectionEndpoint endpoint = this.endpointRef.get();
        if (endpoint != null) {
            endpoint.close();
            this.log.debug("Disconnected");
        }
    }

    @Override
    public void upgradeTls(HttpClientContext context) throws IOException {
        ConnectionEndpoint endpoint = this.ensureValid();
        this.manager.upgrade(endpoint, (HttpContext)context);
    }

    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, HttpClientContext context) throws IOException, HttpException {
        ConnectionEndpoint endpoint = this.ensureValid();
        if (!endpoint.isConnected()) {
            this.connectEndpoint(endpoint, context);
        }
        return endpoint.execute(request, this.requestExecutor, (HttpContext)context);
    }

    @Override
    public boolean isConnectionReusable() {
        return this.reusable;
    }

    @Override
    public void markConnectionReusable() {
        this.reusable = true;
    }

    @Override
    public void markConnectionNonReusable() {
        this.reusable = false;
    }

    @Override
    public void setConnectionState(Object state) {
        this.state = state;
    }

    @Override
    public void setConnectionValidFor(TimeValue duration) {
        this.validDuration = duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnection() {
        ConnectionEndpoint endpoint = this.endpointRef.getAndSet(null);
        if (endpoint != null) {
            if (this.reusable) {
                this.manager.release(endpoint, this.state, this.validDuration);
            } else {
                try {
                    endpoint.close();
                    this.log.debug("Connection discarded");
                }
                catch (IOException ex) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(ex.getMessage(), (Throwable)ex);
                    }
                }
                finally {
                    this.manager.release(endpoint, null, TimeValue.ZERO_MILLISECONDS);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discardConnection() {
        ConnectionEndpoint endpoint = this.endpointRef.getAndSet(null);
        if (endpoint != null) {
            try {
                endpoint.shutdown(ShutdownType.IMMEDIATE);
                this.log.debug("Connection discarded");
            }
            finally {
                this.manager.release(endpoint, null, TimeValue.ZERO_MILLISECONDS);
            }
        }
    }

    public boolean cancel() {
        boolean alreadyReleased = this.endpointRef.get() == null;
        this.log.debug("Cancelling request execution");
        this.discardConnection();
        return !alreadyReleased;
    }
}

