/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.List;
import java.util.Set;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.ByteArrayBuffer;

class CombinedEntity
implements HttpEntity {
    private final HttpEntity entity;
    private final InputStream combinedStream;

    CombinedEntity(HttpEntity entity, ByteArrayBuffer buf) throws IOException {
        this.entity = entity;
        this.combinedStream = new SequenceInputStream(new ByteArrayInputStream(buf.array(), 0, buf.length()), entity.getContent());
    }

    public long getContentLength() {
        return -1L;
    }

    public String getContentType() {
        return this.entity.getContentType();
    }

    public String getContentEncoding() {
        return this.entity.getContentEncoding();
    }

    public boolean isChunked() {
        return true;
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isStreaming() {
        return true;
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        return this.combinedStream;
    }

    public Set<String> getTrailerNames() {
        return this.entity.getTrailerNames();
    }

    public Supplier<List<? extends Header>> getTrailers() {
        return this.entity.getTrailers();
    }

    public void writeTo(OutputStream outstream) throws IOException {
        Args.notNull((Object)outstream, (String)"Output stream");
        try (InputStream instream = this.getContent();){
            int l;
            byte[] tmp = new byte[2048];
            while ((l = instream.read(tmp)) != -1) {
                outstream.write(tmp, 0, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.combinedStream.close();
        }
        finally {
            this.entity.close();
        }
    }
}

