/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.Date;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.client5.http.impl.cache.CacheValidityPolicy;
import org.apache.hc.client5.http.impl.cache.RequestProtocolError;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicHeader;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
class CachedHttpResponseGenerator {
    private final CacheValidityPolicy validityStrategy;

    CachedHttpResponseGenerator(CacheValidityPolicy validityStrategy) {
        this.validityStrategy = validityStrategy;
    }

    SimpleHttpResponse generateResponse(HttpRequest request, HttpCacheEntry entry) throws ResourceIOException {
        long age;
        Date now = new Date();
        SimpleHttpResponse response = new SimpleHttpResponse(entry.getStatus());
        response.setVersion((ProtocolVersion)HttpVersion.DEFAULT);
        response.setHeaders(entry.getAllHeaders());
        if (this.responseShouldContainEntity(request, entry)) {
            Resource resource = entry.getResource();
            Header h = entry.getFirstHeader("Content-Type");
            ContentType contentType = h != null ? ContentType.parse((CharSequence)h.getValue()) : null;
            byte[] content = resource.get();
            this.addMissingContentLengthHeader((HttpResponse)response, content);
            response.setBodyBytes(content, contentType);
        }
        if ((age = this.validityStrategy.getCurrentAgeSecs(entry, now)) > 0L) {
            if (age >= Integer.MAX_VALUE) {
                response.setHeader("Age", "2147483648");
            } else {
                response.setHeader("Age", "" + (int)age);
            }
        }
        return response;
    }

    SimpleHttpResponse generateNotModifiedResponse(HttpCacheEntry entry) {
        Header varyHeader;
        Header cacheControlHeader;
        Header expiresHeader;
        Header contentLocationHeader;
        SimpleHttpResponse response = new SimpleHttpResponse(304, "Not Modified");
        Header dateHeader = entry.getFirstHeader("Date");
        if (dateHeader == null) {
            dateHeader = new BasicHeader("Date", (Object)DateUtils.formatDate(new Date()));
        }
        response.addHeader(dateHeader);
        Header etagHeader = entry.getFirstHeader("ETag");
        if (etagHeader != null) {
            response.addHeader(etagHeader);
        }
        if ((contentLocationHeader = entry.getFirstHeader("Content-Location")) != null) {
            response.addHeader(contentLocationHeader);
        }
        if ((expiresHeader = entry.getFirstHeader("Expires")) != null) {
            response.addHeader(expiresHeader);
        }
        if ((cacheControlHeader = entry.getFirstHeader("Cache-Control")) != null) {
            response.addHeader(cacheControlHeader);
        }
        if ((varyHeader = entry.getFirstHeader("Vary")) != null) {
            response.addHeader(varyHeader);
        }
        return response;
    }

    private void addMissingContentLengthHeader(HttpResponse response, byte[] body) {
        if (this.transferEncodingIsPresent(response)) {
            return;
        }
        Header contentLength = response.getFirstHeader("Content-Length");
        if (contentLength == null) {
            response.setHeader("Content-Length", (Object)Integer.toString(body.length));
        }
    }

    private boolean transferEncodingIsPresent(HttpResponse response) {
        Header hdr = response.getFirstHeader("Transfer-Encoding");
        return hdr != null;
    }

    private boolean responseShouldContainEntity(HttpRequest request, HttpCacheEntry cacheEntry) {
        return request.getMethod().equals("GET") && cacheEntry.getResource() != null;
    }

    public SimpleHttpResponse getErrorForRequest(RequestProtocolError errorCheck) {
        switch (errorCheck) {
            case BODY_BUT_NO_LENGTH_ERROR: {
                return SimpleHttpResponse.create(411);
            }
            case WEAK_ETAG_AND_RANGE_ERROR: {
                return SimpleHttpResponse.create(400, "Weak eTag not compatible with byte range", ContentType.DEFAULT_TEXT);
            }
            case WEAK_ETAG_ON_PUTDELETE_METHOD_ERROR: {
                return SimpleHttpResponse.create(400, "Weak eTag not compatible with PUT or DELETE requests");
            }
            case NO_CACHE_DIRECTIVE_WITH_FIELD_NAME: {
                return SimpleHttpResponse.create(400, "No-Cache directive MUST NOT include a field name");
            }
        }
        throw new IllegalStateException("The request was compliant, therefore no error can be generated for it.");
    }
}

