/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.Resource;
import org.apache.hc.client5.http.cache.ResourceFactory;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.client5.http.impl.cache.HeapResourceFactory;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
class CacheEntryUpdater {
    private final ResourceFactory resourceFactory;

    CacheEntryUpdater() {
        this(new HeapResourceFactory());
    }

    CacheEntryUpdater(ResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    public HttpCacheEntry updateCacheEntry(String requestId, HttpCacheEntry entry, Date requestDate, Date responseDate, HttpResponse response) throws ResourceIOException {
        Args.check((response.getCode() == 304 ? 1 : 0) != 0, (String)"Response must have 304 status code");
        Header[] mergedHeaders = this.mergeHeaders(entry, response);
        Resource resource = null;
        if (entry.getResource() != null) {
            resource = this.resourceFactory.copy(requestId, entry.getResource());
        }
        return new HttpCacheEntry(requestDate, responseDate, entry.getStatus(), mergedHeaders, resource);
    }

    protected Header[] mergeHeaders(HttpCacheEntry entry, HttpResponse response) {
        if (this.entryAndResponseHaveDateHeader(entry, response) && this.entryDateHeaderNewerThenResponse(entry, response)) {
            return entry.getAllHeaders();
        }
        ArrayList<Header> cacheEntryHeaderList = new ArrayList<Header>(Arrays.asList(entry.getAllHeaders()));
        this.removeCacheHeadersThatMatchResponse(cacheEntryHeaderList, response);
        this.removeCacheEntry1xxWarnings(cacheEntryHeaderList, entry);
        cacheEntryHeaderList.addAll(Arrays.asList(response.getAllHeaders()));
        return cacheEntryHeaderList.toArray(new Header[cacheEntryHeaderList.size()]);
    }

    private void removeCacheHeadersThatMatchResponse(List<Header> cacheEntryHeaderList, HttpResponse response) {
        for (Header responseHeader : response.getAllHeaders()) {
            ListIterator<Header> cacheEntryHeaderListIter = cacheEntryHeaderList.listIterator();
            while (cacheEntryHeaderListIter.hasNext()) {
                String cacheEntryHeaderName = cacheEntryHeaderListIter.next().getName();
                if (!cacheEntryHeaderName.equals(responseHeader.getName())) continue;
                cacheEntryHeaderListIter.remove();
            }
        }
    }

    private void removeCacheEntry1xxWarnings(List<Header> cacheEntryHeaderList, HttpCacheEntry entry) {
        ListIterator<Header> cacheEntryHeaderListIter = cacheEntryHeaderList.listIterator();
        while (cacheEntryHeaderListIter.hasNext()) {
            String cacheEntryHeaderName = cacheEntryHeaderListIter.next().getName();
            if (!"Warning".equals(cacheEntryHeaderName)) continue;
            for (Header cacheEntryWarning : entry.getHeaders("Warning")) {
                if (!cacheEntryWarning.getValue().startsWith("1")) continue;
                cacheEntryHeaderListIter.remove();
            }
        }
    }

    private boolean entryDateHeaderNewerThenResponse(HttpCacheEntry entry, HttpResponse response) {
        Date entryDate = DateUtils.parseDate(entry.getFirstHeader("Date").getValue());
        Date responseDate = DateUtils.parseDate(response.getFirstHeader("Date").getValue());
        if (entryDate == null || responseDate == null) {
            return false;
        }
        return entryDate.after(responseDate);
    }

    private boolean entryAndResponseHaveDateHeader(HttpCacheEntry entry, HttpResponse response) {
        return entry.getFirstHeader("Date") != null && response.getFirstHeader("Date") != null;
    }
}

