/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.async.methods.SimpleBody;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.cache.CacheResponseStatus;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.HttpCacheStorage;
import org.apache.hc.client5.http.cache.ResourceFactory;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.client5.http.impl.RequestCopier;
import org.apache.hc.client5.http.impl.cache.BasicHttpCache;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CacheValidityPolicy;
import org.apache.hc.client5.http.impl.cache.CacheableRequestPolicy;
import org.apache.hc.client5.http.impl.cache.CachedHttpResponseGenerator;
import org.apache.hc.client5.http.impl.cache.CachedResponseSuitabilityChecker;
import org.apache.hc.client5.http.impl.cache.CachingExecBase;
import org.apache.hc.client5.http.impl.cache.ConditionalRequestBuilder;
import org.apache.hc.client5.http.impl.cache.HttpCache;
import org.apache.hc.client5.http.impl.cache.RequestProtocolCompliance;
import org.apache.hc.client5.http.impl.cache.ResponseCachingPolicy;
import org.apache.hc.client5.http.impl.cache.ResponseProtocolCompliance;
import org.apache.hc.client5.http.impl.cache.Variant;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.impl.BasicEntityDetails;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.ByteArrayBuffer;

@Contract(threading=ThreadingBehavior.SAFE)
public class AsyncCachingExec
extends CachingExecBase
implements AsyncExecChainHandler {
    private final ConditionalRequestBuilder<HttpRequest> conditionalRequestBuilder;

    public AsyncCachingExec(HttpCache cache, CacheConfig config) {
        super(cache, config);
        this.conditionalRequestBuilder = new ConditionalRequestBuilder<HttpRequest>(RequestCopier.INSTANCE);
    }

    public AsyncCachingExec(ResourceFactory resourceFactory, HttpCacheStorage storage, CacheConfig config) {
        this(new BasicHttpCache(resourceFactory, storage), config);
    }

    public AsyncCachingExec() {
        this(new BasicHttpCache(), CacheConfig.DEFAULT);
    }

    AsyncCachingExec(HttpCache responseCache, CacheValidityPolicy validityPolicy, ResponseCachingPolicy responseCachingPolicy, CachedHttpResponseGenerator responseGenerator, CacheableRequestPolicy cacheableRequestPolicy, CachedResponseSuitabilityChecker suitabilityChecker, ConditionalRequestBuilder<HttpRequest> conditionalRequestBuilder, ResponseProtocolCompliance responseCompliance, RequestProtocolCompliance requestCompliance, CacheConfig config) {
        super(responseCache, validityPolicy, responseCachingPolicy, responseGenerator, cacheableRequestPolicy, suitabilityChecker, responseCompliance, requestCompliance, config);
        this.conditionalRequestBuilder = conditionalRequestBuilder;
    }

    private void triggerResponse(SimpleHttpResponse cacheResponse, AsyncExecChain.Scope scope, AsyncExecCallback asyncExecCallback) {
        scope.clientContext.setAttribute("http.response", (Object)cacheResponse);
        scope.execRuntime.releaseConnection();
        SimpleBody body = cacheResponse.getBody();
        byte[] content = body != null ? body.getBodyBytes() : null;
        ContentType contentType = body != null ? body.getContentType() : null;
        try {
            AsyncDataConsumer dataConsumer = asyncExecCallback.handleResponse((HttpResponse)cacheResponse, (EntityDetails)(content != null ? new BasicEntityDetails((long)content.length, contentType) : null));
            if (dataConsumer != null) {
                dataConsumer.consume(ByteBuffer.wrap(content));
                dataConsumer.streamEnd(null);
            }
        }
        catch (IOException | HttpException ex) {
            asyncExecCallback.failed((Exception)ex);
        }
    }

    @Override
    public void execute(HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)scope, (String)"Scope");
        HttpRoute route = scope.route;
        HttpClientContext context = scope.clientContext;
        context.setAttribute("http.route", route);
        context.setAttribute("http.request", request);
        URIAuthority authority = request.getAuthority();
        String scheme = request.getScheme();
        HttpHost target = authority != null ? new HttpHost((NamedEndpoint)authority, scheme) : route.getTargetHost();
        String via = this.generateViaHeader((HttpMessage)request);
        this.setResponseStatus((HttpContext)context, CacheResponseStatus.CACHE_MISS);
        if (this.clientRequestsOurOptions(request)) {
            this.setResponseStatus((HttpContext)context, CacheResponseStatus.CACHE_MODULE_RESPONSE);
            this.triggerResponse(SimpleHttpResponse.create(501), scope, asyncExecCallback);
            return;
        }
        SimpleHttpResponse fatalErrorResponse = this.getFatallyNoncompliantResponse(request, (HttpContext)context);
        if (fatalErrorResponse != null) {
            this.triggerResponse(fatalErrorResponse, scope, asyncExecCallback);
            return;
        }
        this.requestCompliance.makeRequestCompliant(request);
        request.addHeader("Via", (Object)via);
        if (!this.cacheableRequestPolicy.isServableFromCache(request)) {
            this.log.debug("Request is not servable from cache");
            this.flushEntriesInvalidatedByRequest(target, request);
            this.callBackend(target, request, entityProducer, scope, chain, asyncExecCallback);
        } else {
            HttpCacheEntry entry = this.satisfyFromCache(target, request);
            if (entry == null) {
                this.log.debug("Cache miss");
                this.handleCacheMiss(target, request, entityProducer, scope, chain, asyncExecCallback);
            } else {
                this.handleCacheHit(target, request, entityProducer, scope, chain, asyncExecCallback, entry);
            }
        }
    }

    void callBackend(HttpHost target, HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, final AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        this.callBackendInternal(target, request, entityProducer, scope, chain, new InternalCallback(){

            @Override
            public boolean cacheResponse(HttpResponse backendResponse) {
                return true;
            }

            @Override
            public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                return asyncExecCallback.handleResponse(response, entityDetails);
            }

            @Override
            public void completed() {
                asyncExecCallback.completed();
            }

            @Override
            public void failed(Exception cause) {
                asyncExecCallback.failed(cause);
            }
        });
    }

    void callBackendInternal(final HttpHost target, final HttpRequest request, AsyncEntityProducer entityProducer, final AsyncExecChain.Scope scope, AsyncExecChain chain, final InternalCallback asyncExecCallback) throws HttpException, IOException {
        this.log.debug("Calling the backend");
        final Date requestDate = this.getCurrentDate();
        chain.proceed(request, entityProducer, scope, new AsyncExecCallback(){
            private final AtomicReference<ByteArrayBuffer> bufferRef = new AtomicReference();
            private final AtomicReference<AsyncDataConsumer> dataConsumerRef = new AtomicReference();
            private final AtomicReference<SimpleHttpResponse> responseRef = new AtomicReference();

            @Override
            public AsyncDataConsumer handleResponse(final HttpResponse backendResponse, final EntityDetails entityDetails) throws HttpException, IOException {
                final Date responseDate = AsyncCachingExec.this.getCurrentDate();
                backendResponse.addHeader("Via", (Object)AsyncCachingExec.this.generateViaHeader((HttpMessage)backendResponse));
                AsyncCachingExec.this.responseCompliance.ensureProtocolCompliance(scope.originalRequest, request, backendResponse);
                boolean cacheable = asyncExecCallback.cacheResponse(backendResponse) && AsyncCachingExec.this.responseCachingPolicy.isResponseCacheable(request, backendResponse);
                AsyncCachingExec.this.responseCache.flushInvalidatedCacheEntriesFor(target, request, backendResponse);
                if (cacheable) {
                    if (!AsyncCachingExec.this.alreadyHaveNewerCacheEntry(target, request, backendResponse)) {
                        AsyncCachingExec.this.storeRequestIfModifiedSinceFor304Response(request, backendResponse);
                        this.bufferRef.set(new ByteArrayBuffer(1024));
                    }
                } else {
                    AsyncCachingExec.this.log.debug("Backend response is not cacheable");
                    try {
                        AsyncCachingExec.this.responseCache.flushCacheEntriesFor(target, request);
                    }
                    catch (IOException ioe) {
                        AsyncCachingExec.this.log.warn("Unable to flush invalid cache entries", (Throwable)ioe);
                    }
                }
                if (this.bufferRef.get() != null) {
                    AsyncCachingExec.this.log.debug("Caching backend response");
                    if (entityDetails == null) {
                        scope.execRuntime.releaseConnection();
                        HttpCacheEntry entry = AsyncCachingExec.this.responseCache.createCacheEntry(target, request, backendResponse, null, requestDate, responseDate);
                        AsyncCachingExec.this.log.debug("Backend response successfully cached");
                        this.responseRef.set(AsyncCachingExec.this.responseGenerator.generateResponse(request, entry));
                        return null;
                    }
                    return new AsyncDataConsumer(){

                        public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
                            AsyncDataConsumer dataConsumer = (AsyncDataConsumer)dataConsumerRef.get();
                            if (dataConsumer != null) {
                                dataConsumer.updateCapacity(capacityChannel);
                            } else {
                                capacityChannel.update(Integer.MAX_VALUE);
                            }
                        }

                        public final int consume(ByteBuffer src) throws IOException {
                            ByteArrayBuffer buffer = (ByteArrayBuffer)bufferRef.get();
                            if (buffer != null) {
                                if (src.hasArray()) {
                                    buffer.append(src.array(), src.arrayOffset() + src.position(), src.remaining());
                                } else {
                                    while (src.hasRemaining()) {
                                        buffer.append((int)src.get());
                                    }
                                }
                                if ((long)buffer.length() > AsyncCachingExec.this.cacheConfig.getMaxObjectSize()) {
                                    AsyncCachingExec.this.log.debug("Backend response content length exceeds maximum");
                                    bufferRef.set(null);
                                    try {
                                        AsyncDataConsumer dataConsumer = asyncExecCallback.handleResponse(backendResponse, entityDetails);
                                        if (dataConsumer != null) {
                                            dataConsumerRef.set(dataConsumer);
                                            return dataConsumer.consume(ByteBuffer.wrap(buffer.array(), 0, buffer.length()));
                                        }
                                    }
                                    catch (HttpException ex) {
                                        asyncExecCallback.failed((Exception)((Object)ex));
                                    }
                                }
                                return Integer.MAX_VALUE;
                            }
                            AsyncDataConsumer dataConsumer = (AsyncDataConsumer)dataConsumerRef.get();
                            if (dataConsumer != null) {
                                return dataConsumer.consume(src);
                            }
                            return Integer.MAX_VALUE;
                        }

                        public final void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
                            ByteArrayBuffer buffer;
                            scope.execRuntime.releaseConnection();
                            AsyncDataConsumer dataConsumer = dataConsumerRef.getAndSet(null);
                            if (dataConsumer != null) {
                                dataConsumer.streamEnd(trailers);
                            }
                            if ((buffer = (ByteArrayBuffer)bufferRef.getAndSet(null)) != null) {
                                HttpCacheEntry entry = AsyncCachingExec.this.responseCache.createCacheEntry(target, request, backendResponse, buffer, requestDate, responseDate);
                                AsyncCachingExec.this.log.debug("Backend response successfully cached");
                                responseRef.set(AsyncCachingExec.this.responseGenerator.generateResponse(request, entry));
                            }
                        }

                        public void releaseResources() {
                            AsyncDataConsumer dataConsumer = dataConsumerRef.getAndSet(null);
                            if (dataConsumer != null) {
                                dataConsumer.releaseResources();
                            }
                        }
                    };
                }
                return asyncExecCallback.handleResponse(backendResponse, entityDetails);
            }

            @Override
            public void completed() {
                SimpleHttpResponse response = this.responseRef.getAndSet(null);
                if (response != null) {
                    AsyncCachingExec.this.triggerResponse(response, scope, asyncExecCallback);
                } else {
                    asyncExecCallback.completed();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(Exception cause) {
                try {
                    scope.execRuntime.discardConnection();
                }
                finally {
                    asyncExecCallback.failed(cause);
                }
            }
        });
    }

    private void handleCacheHit(HttpHost target, HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback, HttpCacheEntry entry) throws IOException, HttpException {
        block9: {
            HttpClientContext context = scope.clientContext;
            this.recordCacheHit(target, request);
            Date now = this.getCurrentDate();
            if (this.suitabilityChecker.canCachedResponseBeUsed(target, request, entry, now)) {
                this.log.debug("Cache hit");
                try {
                    SimpleHttpResponse cacheResponse = this.generateCachedResponse(request, (HttpContext)context, entry, now);
                    this.triggerResponse(cacheResponse, scope, asyncExecCallback);
                }
                catch (ResourceIOException ex) {
                    this.recordCacheFailure(target, request);
                    if (!this.mayCallBackend(request)) {
                        SimpleHttpResponse cacheResponse = this.generateGatewayTimeout((HttpContext)context);
                        this.triggerResponse(cacheResponse, scope, asyncExecCallback);
                        break block9;
                    }
                    this.setResponseStatus((HttpContext)scope.clientContext, CacheResponseStatus.FAILURE);
                    chain.proceed(request, entityProducer, scope, asyncExecCallback);
                }
            } else if (!this.mayCallBackend(request)) {
                this.log.debug("Cache entry not suitable but only-if-cached requested");
                SimpleHttpResponse cacheResponse = this.generateGatewayTimeout((HttpContext)context);
                this.triggerResponse(cacheResponse, scope, asyncExecCallback);
            } else if (entry.getStatus() != 304 || this.suitabilityChecker.isConditional(request)) {
                this.log.debug("Revalidating cache entry");
                this.revalidateCacheEntry(target, request, entityProducer, scope, chain, asyncExecCallback, entry);
            } else {
                this.log.debug("Cache entry not usable; calling backend");
                this.callBackend(target, request, entityProducer, scope, chain, asyncExecCallback);
            }
        }
    }

    void revalidateCacheEntry(final HttpHost target, final HttpRequest request, final AsyncEntityProducer entityProducer, final AsyncExecChain.Scope scope, final AsyncExecChain chain, final AsyncExecCallback asyncExecCallback, final HttpCacheEntry cacheEntry) throws IOException, HttpException {
        final Date requestDate = this.getCurrentDate();
        final InternalCallback internalCallback = new InternalCallback(){
            private final AtomicReference<Date> responseDateRef = new AtomicReference<Object>(null);
            private final AtomicReference<HttpResponse> backendResponseRef = new AtomicReference<Object>(null);

            @Override
            public boolean cacheResponse(HttpResponse backendResponse) throws IOException {
                Date responseDate = AsyncCachingExec.this.getCurrentDate();
                this.responseDateRef.set(requestDate);
                int statusCode = backendResponse.getCode();
                if (statusCode == 304 || statusCode == 200) {
                    AsyncCachingExec.this.recordCacheUpdate((HttpContext)scope.clientContext);
                }
                if (statusCode == 304) {
                    this.backendResponseRef.set(backendResponse);
                    return false;
                }
                if (AsyncCachingExec.this.staleIfErrorAppliesTo(statusCode) && !AsyncCachingExec.this.staleResponseNotAllowed(request, cacheEntry, AsyncCachingExec.this.getCurrentDate()) && AsyncCachingExec.this.validityPolicy.mayReturnStaleIfError(request, cacheEntry, responseDate)) {
                    this.backendResponseRef.set(backendResponse);
                    return false;
                }
                return true;
            }

            @Override
            public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                if (this.backendResponseRef.get() == null) {
                    return asyncExecCallback.handleResponse(response, entityDetails);
                }
                return null;
            }

            @Override
            public void completed() {
                HttpResponse backendResponse = this.backendResponseRef.getAndSet(null);
                if (backendResponse != null) {
                    int statusCode = backendResponse.getCode();
                    try {
                        if (statusCode == 304) {
                            HttpCacheEntry updatedEntry = AsyncCachingExec.this.responseCache.updateCacheEntry(target, request, cacheEntry, backendResponse, requestDate, this.responseDateRef.get());
                            if (AsyncCachingExec.this.suitabilityChecker.isConditional(request) && AsyncCachingExec.this.suitabilityChecker.allConditionalsMatch(request, updatedEntry, new Date())) {
                                SimpleHttpResponse cacheResponse = AsyncCachingExec.this.responseGenerator.generateNotModifiedResponse(updatedEntry);
                                AsyncCachingExec.this.triggerResponse(cacheResponse, scope, asyncExecCallback);
                            } else {
                                SimpleHttpResponse cacheResponse = AsyncCachingExec.this.responseGenerator.generateResponse(request, updatedEntry);
                                AsyncCachingExec.this.triggerResponse(cacheResponse, scope, asyncExecCallback);
                            }
                        } else if (AsyncCachingExec.this.staleIfErrorAppliesTo(statusCode)) {
                            SimpleHttpResponse cacheResponse = AsyncCachingExec.this.responseGenerator.generateResponse(request, cacheEntry);
                            cacheResponse.addHeader("Warning", "110 localhost \"Response is stale\"");
                            AsyncCachingExec.this.triggerResponse(cacheResponse, scope, asyncExecCallback);
                        }
                    }
                    catch (IOException ex) {
                        asyncExecCallback.failed(ex);
                    }
                } else {
                    asyncExecCallback.completed();
                }
            }

            @Override
            public void failed(Exception cause) {
                asyncExecCallback.failed(cause);
            }
        };
        HttpRequest conditionalRequest = this.conditionalRequestBuilder.buildConditionalRequest(scope.originalRequest, cacheEntry);
        this.callBackendInternal(target, conditionalRequest, entityProducer, scope, chain, new InternalCallback(){
            private final AtomicBoolean revalidate = new AtomicBoolean(false);

            @Override
            public boolean cacheResponse(HttpResponse backendResponse) throws HttpException, IOException {
                if (AsyncCachingExec.this.revalidationResponseIsTooOld(backendResponse, cacheEntry)) {
                    this.revalidate.set(true);
                    return false;
                }
                return internalCallback.cacheResponse(backendResponse);
            }

            @Override
            public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                if (this.revalidate.get()) {
                    return null;
                }
                return internalCallback.handleResponse(response, entityDetails);
            }

            @Override
            public void completed() {
                if (this.revalidate.getAndSet(false)) {
                    HttpRequest unconditionalRequest = AsyncCachingExec.this.conditionalRequestBuilder.buildUnconditionalRequest(scope.originalRequest);
                    try {
                        AsyncCachingExec.this.callBackendInternal(target, unconditionalRequest, entityProducer, scope, chain, new InternalCallback(){

                            @Override
                            public boolean cacheResponse(HttpResponse backendResponse) throws HttpException, IOException {
                                return internalCallback.cacheResponse(backendResponse);
                            }

                            @Override
                            public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                                return internalCallback.handleResponse(response, entityDetails);
                            }

                            @Override
                            public void completed() {
                                internalCallback.completed();
                            }

                            @Override
                            public void failed(Exception cause) {
                                internalCallback.failed(cause);
                            }
                        });
                    }
                    catch (IOException | HttpException ex) {
                        internalCallback.failed((Exception)ex);
                    }
                } else {
                    internalCallback.completed();
                }
            }

            @Override
            public void failed(Exception cause) {
                internalCallback.failed(cause);
            }
        });
    }

    private void handleCacheMiss(HttpHost target, HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback) throws IOException, HttpException {
        this.recordCacheMiss(target, request);
        if (!this.mayCallBackend(request)) {
            SimpleHttpResponse cacheResponse = SimpleHttpResponse.create(504, "Gateway Timeout");
            this.triggerResponse(cacheResponse, scope, asyncExecCallback);
            return;
        }
        Map<String, Variant> variants = this.getExistingCacheVariants(target, request);
        if (variants != null && !variants.isEmpty()) {
            this.negotiateResponseFromVariants(target, request, entityProducer, scope, chain, asyncExecCallback, variants);
        } else {
            this.callBackend(target, request, entityProducer, scope, chain, asyncExecCallback);
        }
    }

    void negotiateResponseFromVariants(final HttpHost target, final HttpRequest request, final AsyncEntityProducer entityProducer, final AsyncExecChain.Scope scope, final AsyncExecChain chain, final AsyncExecCallback asyncExecCallback, final Map<String, Variant> variants) throws IOException, HttpException {
        final HttpRequest conditionalRequest = this.conditionalRequestBuilder.buildConditionalRequestFromVariants(request, variants);
        final Date requestDate = this.getCurrentDate();
        this.callBackendInternal(target, conditionalRequest, entityProducer, scope, chain, new InternalCallback(){
            private final AtomicReference<Date> responseDateRef = new AtomicReference<Object>(null);
            private final AtomicReference<HttpResponse> backendResponseRef = new AtomicReference<Object>(null);

            @Override
            public boolean cacheResponse(HttpResponse backendResponse) throws IOException {
                this.responseDateRef.set(AsyncCachingExec.this.getCurrentDate());
                if (backendResponse.getCode() == 304) {
                    this.backendResponseRef.set(backendResponse);
                    return false;
                }
                return true;
            }

            @Override
            public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                return asyncExecCallback.handleResponse(response, entityDetails);
            }

            @Override
            public void completed() {
                block10: {
                    HttpResponse backendResponse = this.backendResponseRef.getAndSet(null);
                    if (backendResponse != null) {
                        try {
                            Header resultEtagHeader = backendResponse.getFirstHeader("ETag");
                            if (resultEtagHeader == null) {
                                AsyncCachingExec.this.log.warn("304 response did not contain ETag");
                                AsyncCachingExec.this.callBackend(target, request, entityProducer, scope, chain, asyncExecCallback);
                                return;
                            }
                            String resultEtag = resultEtagHeader.getValue();
                            Variant matchingVariant = (Variant)variants.get(resultEtag);
                            if (matchingVariant == null) {
                                AsyncCachingExec.this.log.debug("304 response did not contain ETag matching one sent in If-None-Match");
                                AsyncCachingExec.this.callBackend(target, request, entityProducer, scope, chain, asyncExecCallback);
                                return;
                            }
                            HttpCacheEntry matchedEntry = matchingVariant.getEntry();
                            if (AsyncCachingExec.this.revalidationResponseIsTooOld(backendResponse, matchedEntry)) {
                                HttpRequest unconditional = AsyncCachingExec.this.conditionalRequestBuilder.buildUnconditionalRequest(request);
                                scope.clientContext.setAttribute("http.request", unconditional);
                                AsyncCachingExec.this.callBackend(target, unconditional, entityProducer, scope, chain, asyncExecCallback);
                                return;
                            }
                            AsyncCachingExec.this.recordCacheUpdate((HttpContext)scope.clientContext);
                            HttpCacheEntry responseEntry = matchedEntry;
                            try {
                                responseEntry = AsyncCachingExec.this.responseCache.updateVariantCacheEntry(target, conditionalRequest, matchedEntry, backendResponse, requestDate, this.responseDateRef.get(), matchingVariant.getCacheKey());
                            }
                            catch (IOException ioe) {
                                AsyncCachingExec.this.log.warn("Could not processChallenge cache entry", (Throwable)ioe);
                            }
                            if (AsyncCachingExec.this.shouldSendNotModifiedResponse(request, responseEntry)) {
                                SimpleHttpResponse cacheResponse = AsyncCachingExec.this.responseGenerator.generateNotModifiedResponse(responseEntry);
                                AsyncCachingExec.this.triggerResponse(cacheResponse, scope, asyncExecCallback);
                                break block10;
                            }
                            SimpleHttpResponse cacheResponse = AsyncCachingExec.this.responseGenerator.generateResponse(request, responseEntry);
                            AsyncCachingExec.this.tryToUpdateVariantMap(target, request, matchingVariant);
                            AsyncCachingExec.this.triggerResponse(cacheResponse, scope, asyncExecCallback);
                        }
                        catch (IOException | HttpException ex) {
                            asyncExecCallback.failed((Exception)ex);
                        }
                    } else {
                        asyncExecCallback.completed();
                    }
                }
            }

            @Override
            public void failed(Exception cause) {
                asyncExecCallback.failed(cause);
            }
        });
    }

    static interface InternalCallback
    extends AsyncExecCallback {
        public boolean cacheResponse(HttpResponse var1) throws HttpException, IOException;
    }
}

