/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.config.Configurable;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.impl.ExecSupport;
import org.apache.hc.client5.http.impl.async.AbstractMinimalHttpAsyncClientBase;
import org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import org.apache.hc.client5.http.impl.async.LoggingAsyncClientExchangeHandler;
import org.apache.hc.client5.http.impl.classic.RequestFailedException;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncConnectionEndpoint;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.ComplexFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncClientEndpoint;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import org.apache.hc.core5.reactor.IOEventHandlerFactory;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.Asserts;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public final class MinimalHttpAsyncClient
extends AbstractMinimalHttpAsyncClientBase {
    private final AsyncClientConnectionManager connmgr;
    private final HttpVersionPolicy versionPolicy;

    MinimalHttpAsyncClient(IOEventHandlerFactory eventHandlerFactory, AsyncPushConsumerRegistry pushConsumerRegistry, HttpVersionPolicy versionPolicy, IOReactorConfig reactorConfig, ThreadFactory threadFactory, ThreadFactory workerThreadFactory, AsyncClientConnectionManager connmgr) {
        super(new DefaultConnectingIOReactor(eventHandlerFactory, reactorConfig, workerThreadFactory, null, null, (Callback)new Callback<IOSession>(){

            public void execute(IOSession ioSession) {
                ioSession.addFirst((Command)new ShutdownCommand(ShutdownType.GRACEFUL));
            }
        }), pushConsumerRegistry, threadFactory);
        this.versionPolicy = versionPolicy != null ? versionPolicy : HttpVersionPolicy.NEGOTIATE;
        this.connmgr = connmgr;
    }

    private Future<AsyncConnectionEndpoint> leaseEndpoint(HttpHost host, final Timeout connectTimeout, final HttpClientContext clientContext, final FutureCallback<AsyncConnectionEndpoint> callback) {
        final ComplexFuture resultFuture = new ComplexFuture(callback);
        Future<AsyncConnectionEndpoint> leaseFuture = this.connmgr.lease(new HttpRoute(host), null, connectTimeout, new FutureCallback<AsyncConnectionEndpoint>(){

            public void completed(AsyncConnectionEndpoint connectionEndpoint) {
                if (connectionEndpoint.isConnected()) {
                    resultFuture.completed((Object)connectionEndpoint);
                } else {
                    Future<AsyncConnectionEndpoint> connectFuture = MinimalHttpAsyncClient.this.connmgr.connect(connectionEndpoint, MinimalHttpAsyncClient.this.getConnectionInitiator(), (TimeValue)connectTimeout, MinimalHttpAsyncClient.this.versionPolicy, (HttpContext)clientContext, new FutureCallback<AsyncConnectionEndpoint>(){

                        public void completed(AsyncConnectionEndpoint result) {
                            resultFuture.completed((Object)result);
                        }

                        public void failed(Exception ex) {
                            resultFuture.failed(ex);
                        }

                        public void cancelled() {
                            resultFuture.cancel(true);
                        }
                    });
                    resultFuture.setDependency(connectFuture);
                }
            }

            public void failed(Exception ex) {
                callback.failed(ex);
            }

            public void cancelled() {
                callback.cancelled();
            }
        });
        resultFuture.setDependency(leaseFuture);
        return resultFuture;
    }

    public final Future<AsyncClientEndpoint> lease(HttpHost host, FutureCallback<AsyncClientEndpoint> callback) {
        return this.lease(host, (HttpContext)HttpClientContext.create(), callback);
    }

    public Future<AsyncClientEndpoint> lease(HttpHost host, HttpContext context, FutureCallback<AsyncClientEndpoint> callback) {
        Args.notNull((Object)host, (String)"Host");
        Args.notNull((Object)context, (String)"HTTP context");
        this.ensureRunning();
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig requestConfig = clientContext.getRequestConfig();
        final BasicFuture future = new BasicFuture(callback);
        this.leaseEndpoint(host, requestConfig.getConnectionTimeout(), clientContext, new FutureCallback<AsyncConnectionEndpoint>(){

            public void completed(AsyncConnectionEndpoint result) {
                future.completed((Object)new InternalAsyncClientEndpoint(result));
            }

            public void failed(Exception ex) {
                future.failed(ex);
            }

            public void cancelled() {
                future.cancel(true);
            }
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T> void execute(final AsyncClientExchangeHandler exchangeHandler, HttpContext context, final ComplexFuture<T> resultFuture, final Supplier<T> resultSupplier) {
        this.ensureRunning();
        final HttpClientContext clientContext = HttpClientContext.adapt(context);
        try {
            exchangeHandler.produceRequest(new RequestChannel(){

                public void sendRequest(final HttpRequest request, final EntityDetails entityDetails) throws HttpException, IOException {
                    RequestConfig requestConfig = null;
                    if (request instanceof Configurable) {
                        requestConfig = ((Configurable)request).getConfig();
                    }
                    if (requestConfig != null) {
                        clientContext.setRequestConfig(requestConfig);
                    } else {
                        requestConfig = clientContext.getRequestConfig();
                    }
                    Timeout connectTimeout = requestConfig.getConnectionTimeout();
                    HttpHost target = new HttpHost((NamedEndpoint)request.getAuthority(), request.getScheme());
                    Future leaseFuture = MinimalHttpAsyncClient.this.leaseEndpoint(target, connectTimeout, clientContext, (FutureCallback<AsyncConnectionEndpoint>)((FutureCallback)new FutureCallback<AsyncConnectionEndpoint>(){

                        public void completed(AsyncConnectionEndpoint connectionEndpoint) {
                            final InternalAsyncClientEndpoint endpoint = new InternalAsyncClientEndpoint(connectionEndpoint);
                            final AtomicInteger messageCountDown = new AtomicInteger(2);
                            AsyncClientExchangeHandler internalExchangeHandler = new AsyncClientExchangeHandler(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void releaseResources() {
                                    try {
                                        exchangeHandler.releaseResources();
                                    }
                                    finally {
                                        endpoint.releaseAndDiscard();
                                    }
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void failed(Exception cause) {
                                    try {
                                        exchangeHandler.failed(cause);
                                    }
                                    finally {
                                        endpoint.releaseAndDiscard();
                                    }
                                }

                                public void cancel() {
                                    this.failed(new RequestFailedException("Request aborted"));
                                }

                                public void produceRequest(RequestChannel channel) throws HttpException, IOException {
                                    channel.sendRequest(request, entityDetails);
                                    if (entityDetails == null) {
                                        messageCountDown.decrementAndGet();
                                    }
                                }

                                public int available() {
                                    return exchangeHandler.available();
                                }

                                public void produce(final DataStreamChannel channel) throws IOException {
                                    exchangeHandler.produce(new DataStreamChannel(){

                                        public void requestOutput() {
                                            channel.requestOutput();
                                        }

                                        public int write(ByteBuffer src) throws IOException {
                                            return channel.write((Buffer)src);
                                        }

                                        public void endStream(List<? extends Header> trailers) throws IOException {
                                            channel.endStream(trailers);
                                            if (messageCountDown.decrementAndGet() <= 0) {
                                                endpoint.releaseAndReuse();
                                            }
                                        }

                                        public void endStream() throws IOException {
                                            channel.endStream();
                                            if (messageCountDown.decrementAndGet() <= 0) {
                                                endpoint.releaseAndReuse();
                                            }
                                        }
                                    });
                                }

                                public void consumeInformation(HttpResponse response) throws HttpException, IOException {
                                    exchangeHandler.consumeInformation(response);
                                }

                                public void consumeResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                                    exchangeHandler.consumeResponse(response, entityDetails);
                                    if (response.getCode() >= 400) {
                                        messageCountDown.decrementAndGet();
                                    }
                                    if (entityDetails == null) {
                                        if (messageCountDown.decrementAndGet() <= 0) {
                                            endpoint.releaseAndReuse();
                                        }
                                        resultFuture.completed(resultSupplier.get());
                                    }
                                }

                                public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
                                    exchangeHandler.updateCapacity(capacityChannel);
                                }

                                public int consume(ByteBuffer src) throws IOException {
                                    return exchangeHandler.consume(src);
                                }

                                public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
                                    if (messageCountDown.decrementAndGet() <= 0) {
                                        endpoint.releaseAndReuse();
                                    }
                                    exchangeHandler.streamEnd(trailers);
                                    resultFuture.completed(resultSupplier.get());
                                }
                            };
                            endpoint.execute(internalExchangeHandler, (HttpContext)clientContext);
                        }

                        public void failed(Exception ex) {
                            resultFuture.failed(ex);
                        }

                        public void cancelled() {
                            resultFuture.cancel();
                        }
                    }));
                    if (resultFuture != null) {
                        resultFuture.setDependency(leaseFuture);
                    }
                }
            });
        }
        catch (IOException | HttpException ex) {
            try {
                exchangeHandler.failed((Exception)ex);
            }
            finally {
                resultFuture.failed((Exception)ex);
            }
        }
    }

    private class InternalAsyncClientEndpoint
    extends AsyncClientEndpoint {
        private final AsyncConnectionEndpoint connectionEndpoint;
        private final AtomicBoolean released;

        InternalAsyncClientEndpoint(AsyncConnectionEndpoint connectionEndpoint) {
            this.connectionEndpoint = connectionEndpoint;
            this.released = new AtomicBoolean(false);
        }

        boolean isReleased() {
            return this.released.get();
        }

        public void execute(AsyncClientExchangeHandler exchangeHandler, HttpContext context) {
            Asserts.check((!this.released.get() ? 1 : 0) != 0, (String)"Endpoint has already been released");
            if (MinimalHttpAsyncClient.this.log.isDebugEnabled()) {
                String exchangeId = String.format("ex-%08X", ExecSupport.getNextExecNumber());
                MinimalHttpAsyncClient.this.log.debug(ConnPoolSupport.getId(this.connectionEndpoint) + ": executing message exchange " + exchangeId);
                this.connectionEndpoint.execute(new LoggingAsyncClientExchangeHandler(MinimalHttpAsyncClient.this.log, exchangeId, exchangeHandler), context);
            } else {
                this.connectionEndpoint.execute(exchangeHandler, context);
            }
        }

        public void releaseAndReuse() {
            if (this.released.compareAndSet(false, true)) {
                MinimalHttpAsyncClient.this.connmgr.release(this.connectionEndpoint, null, TimeValue.NEG_ONE_MILLISECONDS);
            }
        }

        public void releaseAndDiscard() {
            if (this.released.compareAndSet(false, true)) {
                try {
                    this.connectionEndpoint.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                MinimalHttpAsyncClient.this.connmgr.release(this.connectionEndpoint, null, TimeValue.ZERO_MILLISECONDS);
            }
        }
    }
}

