/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.impl.Wire;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOEventHandler;
import org.apache.hc.core5.reactor.TlsCapableIOSession;
import org.apache.hc.core5.reactor.ssl.SSLBufferManagement;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.logging.log4j.Logger;

class LoggingIOSession
implements TlsCapableIOSession {
    private final Logger log;
    private final Wire wirelog;
    private final String id;
    private final TlsCapableIOSession session;
    private final ByteChannel channel;

    public LoggingIOSession(TlsCapableIOSession session, String id, Logger log, Logger wirelog) {
        this.session = session;
        this.id = id;
        this.log = log;
        this.wirelog = new Wire(wirelog, this.id);
        this.channel = new LoggingByteChannel();
    }

    public LoggingIOSession(TlsCapableIOSession session, String id, Logger log) {
        this(session, id, log, null);
    }

    public String getId() {
        return this.session.getId();
    }

    public void addLast(Command command) {
        this.session.addLast(command);
    }

    public void addFirst(Command command) {
        this.session.addFirst(command);
    }

    public Command getCommand() {
        return this.session.getCommand();
    }

    public ByteChannel channel() {
        return this.channel;
    }

    public SocketAddress getLocalAddress() {
        return this.session.getLocalAddress();
    }

    public SocketAddress getRemoteAddress() {
        return this.session.getRemoteAddress();
    }

    public int getEventMask() {
        return this.session.getEventMask();
    }

    private static String formatOps(int ops) {
        StringBuilder buffer = new StringBuilder(6);
        buffer.append('[');
        if ((ops & 1) > 0) {
            buffer.append('r');
        }
        if ((ops & 4) > 0) {
            buffer.append('w');
        }
        if ((ops & 0x10) > 0) {
            buffer.append('a');
        }
        if ((ops & 8) > 0) {
            buffer.append('c');
        }
        buffer.append(']');
        return buffer.toString();
    }

    public void setEventMask(int ops) {
        this.session.setEventMask(ops);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " " + this.session + ": Event mask set " + LoggingIOSession.formatOps(ops));
        }
    }

    public void setEvent(int op) {
        this.session.setEvent(op);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " " + this.session + ": Event set " + LoggingIOSession.formatOps(op));
        }
    }

    public void clearEvent(int op) {
        this.session.clearEvent(op);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " " + this.session + ": Event cleared " + LoggingIOSession.formatOps(op));
        }
    }

    public void close() {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " " + this.session + ": Close");
        }
        this.session.close();
    }

    public int getStatus() {
        return this.session.getStatus();
    }

    public boolean isClosed() {
        return this.session.isClosed();
    }

    public void shutdown(ShutdownType shutdownType) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " " + this.session + ": Shutdown " + shutdownType);
        }
        this.session.shutdown(shutdownType);
    }

    public int getSocketTimeout() {
        return this.session.getSocketTimeout();
    }

    public void setSocketTimeout(int timeout) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.id + " " + this.session + ": Set timeout " + timeout);
        }
        this.session.setSocketTimeout(timeout);
    }

    public long getLastReadTime() {
        return this.session.getLastReadTime();
    }

    public long getLastWriteTime() {
        return this.session.getLastWriteTime();
    }

    public void updateReadTime() {
        this.session.updateReadTime();
    }

    public void updateWriteTime() {
        this.session.updateWriteTime();
    }

    public IOEventHandler getHandler() {
        return this.session.getHandler();
    }

    public void setHandler(IOEventHandler handler) {
        this.session.setHandler(handler);
    }

    public void startTls(SSLContext sslContext, SSLBufferManagement sslBufferManagement, SSLSessionInitializer initializer, SSLSessionVerifier verifier) throws UnsupportedOperationException {
        this.session.startTls(sslContext, sslBufferManagement, initializer, verifier);
    }

    public TlsDetails getTlsDetails() {
        return this.session.getTlsDetails();
    }

    public String toString() {
        return this.id + " " + this.session.toString();
    }

    class LoggingByteChannel
    implements ByteChannel {
        LoggingByteChannel() {
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            int bytesRead = LoggingIOSession.this.session.channel().read(dst);
            if (LoggingIOSession.this.log.isDebugEnabled()) {
                LoggingIOSession.this.log.debug(LoggingIOSession.this.id + " " + LoggingIOSession.this.session + ": " + bytesRead + " bytes read");
            }
            if (bytesRead > 0 && LoggingIOSession.this.wirelog.isEnabled()) {
                ByteBuffer b = dst.duplicate();
                int p = b.position();
                b.limit(p);
                b.position(p - bytesRead);
                LoggingIOSession.this.wirelog.input(b);
            }
            return bytesRead;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int byteWritten = LoggingIOSession.this.session.channel().write(src);
            if (LoggingIOSession.this.log.isDebugEnabled()) {
                LoggingIOSession.this.log.debug(LoggingIOSession.this.id + " " + LoggingIOSession.this.session + ": " + byteWritten + " bytes written");
            }
            if (byteWritten > 0 && LoggingIOSession.this.wirelog.isEnabled()) {
                ByteBuffer b = src.duplicate();
                int p = b.position();
                b.limit(p);
                b.position(p - byteWritten);
                LoggingIOSession.this.wirelog.output(b);
            }
            return byteWritten;
        }

        @Override
        public void close() throws IOException {
            if (LoggingIOSession.this.log.isDebugEnabled()) {
                LoggingIOSession.this.log.debug(LoggingIOSession.this.id + " " + LoggingIOSession.this.session + ": Channel close");
            }
            LoggingIOSession.this.session.channel().close();
        }

        @Override
        public boolean isOpen() {
            return LoggingIOSession.this.session.channel().isOpen();
        }
    }
}

