/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.async.AsyncExecRuntime;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.ConnPoolSupport;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncConnectionEndpoint;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.apache.logging.log4j.Logger;

class InternalHttpAsyncExecRuntime
implements AsyncExecRuntime {
    private final Logger log;
    private final AsyncClientConnectionManager manager;
    private final ConnectionInitiator connectionInitiator;
    private final HttpVersionPolicy versionPolicy;
    private final AtomicReference<AsyncConnectionEndpoint> endpointRef;
    private volatile boolean reusable;
    private volatile Object state;
    private volatile TimeValue validDuration;

    InternalHttpAsyncExecRuntime(Logger log, AsyncClientConnectionManager manager, ConnectionInitiator connectionInitiator, HttpVersionPolicy versionPolicy) {
        this.log = log;
        this.manager = manager;
        this.connectionInitiator = connectionInitiator;
        this.versionPolicy = versionPolicy;
        this.endpointRef = new AtomicReference<Object>(null);
        this.validDuration = TimeValue.NEG_ONE_MILLISECONDS;
    }

    @Override
    public boolean isConnectionAcquired() {
        return this.endpointRef.get() != null;
    }

    @Override
    public void acquireConnection(HttpRoute route, Object object, HttpClientContext context, final FutureCallback<AsyncExecRuntime> callback) {
        if (this.endpointRef.get() == null) {
            this.state = object;
            RequestConfig requestConfig = context.getRequestConfig();
            this.manager.lease(route, object, requestConfig.getConnectionRequestTimeout(), new FutureCallback<AsyncConnectionEndpoint>(){

                public void completed(AsyncConnectionEndpoint connectionEndpoint) {
                    InternalHttpAsyncExecRuntime.this.endpointRef.set(connectionEndpoint);
                    InternalHttpAsyncExecRuntime.this.reusable = connectionEndpoint.isConnected();
                    callback.completed((Object)InternalHttpAsyncExecRuntime.this);
                }

                public void failed(Exception ex) {
                    callback.failed(ex);
                }

                public void cancelled() {
                    callback.cancelled();
                }
            });
        } else {
            callback.completed((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discardEndpoint(AsyncConnectionEndpoint endpoint) {
        try {
            endpoint.shutdown();
            if (this.log.isDebugEnabled()) {
                this.log.debug(ConnPoolSupport.getId(endpoint) + ": discarding endpoint");
            }
        }
        catch (IOException ex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(ConnPoolSupport.getId(endpoint) + ": " + ex.getMessage(), (Throwable)ex);
            }
        }
        finally {
            this.manager.release(endpoint, null, TimeValue.ZERO_MILLISECONDS);
        }
    }

    @Override
    public void releaseConnection() {
        AsyncConnectionEndpoint endpoint = this.endpointRef.getAndSet(null);
        if (endpoint != null) {
            if (this.reusable) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(ConnPoolSupport.getId(endpoint) + ": releasing valid endpoint");
                }
                this.manager.release(endpoint, this.state, this.validDuration);
            } else {
                this.discardEndpoint(endpoint);
            }
        }
    }

    @Override
    public void discardConnection() {
        AsyncConnectionEndpoint endpoint = this.endpointRef.getAndSet(null);
        if (endpoint != null) {
            this.discardEndpoint(endpoint);
        }
    }

    @Override
    public boolean validateConnection() {
        if (this.reusable) {
            AsyncConnectionEndpoint endpoint = this.endpointRef.get();
            return endpoint != null && endpoint.isConnected();
        }
        AsyncConnectionEndpoint endpoint = this.endpointRef.getAndSet(null);
        if (endpoint != null) {
            this.discardEndpoint(endpoint);
        }
        return false;
    }

    AsyncConnectionEndpoint ensureValid() {
        AsyncConnectionEndpoint endpoint = this.endpointRef.get();
        if (endpoint == null) {
            throw new IllegalStateException("Endpoint not acquired / already released");
        }
        return endpoint;
    }

    @Override
    public boolean isConnected() {
        AsyncConnectionEndpoint endpoint = this.endpointRef.get();
        return endpoint != null && endpoint.isConnected();
    }

    @Override
    public void connect(HttpClientContext context, FutureCallback<AsyncExecRuntime> callback) {
        AsyncConnectionEndpoint endpoint = this.ensureValid();
        if (endpoint.isConnected()) {
            callback.completed((Object)this);
        } else {
            RequestConfig requestConfig = context.getRequestConfig();
            Timeout timeout = requestConfig.getConnectionTimeout();
            this.manager.connect(endpoint, this.connectionInitiator, (TimeValue)timeout, this.versionPolicy, (HttpContext)context, new FutureCallback<AsyncConnectionEndpoint>((TimeValue)timeout, callback){
                final /* synthetic */ TimeValue val$timeout;
                final /* synthetic */ FutureCallback val$callback;
                {
                    this.val$timeout = timeValue;
                    this.val$callback = futureCallback;
                }

                public void completed(AsyncConnectionEndpoint endpoint) {
                    if (TimeValue.isPositive((TimeValue)this.val$timeout)) {
                        endpoint.setSocketTimeout(this.val$timeout.toMillisIntBound());
                    }
                    this.val$callback.completed((Object)InternalHttpAsyncExecRuntime.this);
                }

                public void failed(Exception ex) {
                    this.val$callback.failed(ex);
                }

                public void cancelled() {
                    this.val$callback.cancelled();
                }
            });
        }
    }

    @Override
    public void upgradeTls(HttpClientContext context) {
        AsyncConnectionEndpoint endpoint = this.ensureValid();
        this.manager.upgrade(endpoint, this.versionPolicy, (HttpContext)context);
    }

    @Override
    public void execute(final AsyncClientExchangeHandler exchangeHandler, final HttpClientContext context) {
        final AsyncConnectionEndpoint endpoint = this.ensureValid();
        if (endpoint.isConnected()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(ConnPoolSupport.getId(endpoint) + ": executing " + ConnPoolSupport.getId(exchangeHandler));
            }
            endpoint.execute(exchangeHandler, (HttpContext)context);
        } else {
            this.connect(context, new FutureCallback<AsyncExecRuntime>(){

                public void completed(AsyncExecRuntime runtime) {
                    if (InternalHttpAsyncExecRuntime.this.log.isDebugEnabled()) {
                        InternalHttpAsyncExecRuntime.this.log.debug(ConnPoolSupport.getId(endpoint) + ": executing " + ConnPoolSupport.getId(exchangeHandler));
                    }
                    try {
                        endpoint.execute(exchangeHandler, (HttpContext)context);
                    }
                    catch (RuntimeException ex) {
                        this.failed(ex);
                    }
                }

                public void failed(Exception ex) {
                    exchangeHandler.failed(ex);
                }

                public void cancelled() {
                    exchangeHandler.failed((Exception)new InterruptedIOException());
                }
            });
        }
    }

    @Override
    public void markConnectionReusable(Object newState, TimeValue newValidDuration) {
        this.reusable = true;
        this.state = newState;
        this.validDuration = newValidDuration;
    }

    @Override
    public void markConnectionNonReusable() {
        this.reusable = false;
        this.state = null;
        this.validDuration = null;
    }
}

