/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.async.methods;

import java.net.URI;
import java.util.Iterator;
import org.apache.hc.client5.http.StandardMethods;
import org.apache.hc.client5.http.async.methods.ConfigurableHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleBody;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.util.Args;

public final class SimpleHttpRequest
extends ConfigurableHttpRequest {
    private RequestConfig requestConfig;
    private SimpleBody body;

    public static SimpleHttpRequest get(URI requestUri) {
        Args.notNull((Object)requestUri, (String)"Request URI");
        return new SimpleHttpRequest(StandardMethods.GET, requestUri);
    }

    public static SimpleHttpRequest get(String requestUri) {
        return new SimpleHttpRequest(StandardMethods.GET, URI.create(requestUri));
    }

    public static SimpleHttpRequest get(HttpHost host, String path) {
        Args.notNull((Object)host, (String)"Host");
        return new SimpleHttpRequest(StandardMethods.GET, host, path);
    }

    public static SimpleHttpRequest post(URI requestUri) {
        Args.notNull((Object)requestUri, (String)"Request URI");
        return new SimpleHttpRequest(StandardMethods.POST, requestUri);
    }

    public static SimpleHttpRequest post(String requestUri) {
        return new SimpleHttpRequest(StandardMethods.POST, URI.create(requestUri));
    }

    public static SimpleHttpRequest post(HttpHost host, String path) {
        Args.notNull((Object)host, (String)"Host");
        return new SimpleHttpRequest(StandardMethods.POST, host, path);
    }

    public static SimpleHttpRequest put(URI requestUri) {
        Args.notNull((Object)requestUri, (String)"Request URI");
        return new SimpleHttpRequest(StandardMethods.PUT, requestUri);
    }

    public static SimpleHttpRequest put(String requestUri) {
        return new SimpleHttpRequest(StandardMethods.PUT, URI.create(requestUri));
    }

    public static SimpleHttpRequest put(HttpHost host, String path) {
        Args.notNull((Object)host, (String)"Host");
        return new SimpleHttpRequest(StandardMethods.PUT, host, path);
    }

    public static SimpleHttpRequest head(URI requestUri) {
        Args.notNull((Object)requestUri, (String)"Request URI");
        return new SimpleHttpRequest(StandardMethods.HEAD, requestUri);
    }

    public static SimpleHttpRequest head(String requestUri) {
        return new SimpleHttpRequest(StandardMethods.HEAD, URI.create(requestUri));
    }

    public static SimpleHttpRequest head(HttpHost host, String path) {
        Args.notNull((Object)host, (String)"Host");
        return new SimpleHttpRequest(StandardMethods.HEAD, host, path);
    }

    public static SimpleHttpRequest delete(URI requestUri) {
        Args.notNull((Object)requestUri, (String)"Request URI");
        return new SimpleHttpRequest(StandardMethods.DELETE, requestUri);
    }

    public static SimpleHttpRequest delete(String requestUri) {
        return new SimpleHttpRequest(StandardMethods.DELETE, URI.create(requestUri));
    }

    public static SimpleHttpRequest delete(HttpHost host, String path) {
        Args.notNull((Object)host, (String)"Host");
        return new SimpleHttpRequest(StandardMethods.DELETE, host, path);
    }

    public static SimpleHttpRequest trace(URI requestUri) {
        Args.notNull((Object)requestUri, (String)"Request URI");
        return new SimpleHttpRequest(StandardMethods.TRACE, requestUri);
    }

    public static SimpleHttpRequest trace(String requestUri) {
        return new SimpleHttpRequest(StandardMethods.TRACE, URI.create(requestUri));
    }

    public static SimpleHttpRequest trace(HttpHost host, String path) {
        Args.notNull((Object)host, (String)"Host");
        return new SimpleHttpRequest(StandardMethods.TRACE, host, path);
    }

    public static SimpleHttpRequest options(URI requestUri) {
        Args.notNull((Object)requestUri, (String)"Request URI");
        return new SimpleHttpRequest(StandardMethods.OPTIONS, requestUri);
    }

    public static SimpleHttpRequest options(String requestUri) {
        return new SimpleHttpRequest(StandardMethods.OPTIONS, URI.create(requestUri));
    }

    public static SimpleHttpRequest options(HttpHost host, String path) {
        Args.notNull((Object)host, (String)"Host");
        return new SimpleHttpRequest(StandardMethods.OPTIONS, host, path);
    }

    public static SimpleHttpRequest patch(URI requestUri) {
        Args.notNull((Object)requestUri, (String)"Request URI");
        return new SimpleHttpRequest(StandardMethods.PATCH, requestUri);
    }

    public static SimpleHttpRequest patch(String requestUri) {
        return new SimpleHttpRequest(StandardMethods.PATCH, URI.create(requestUri));
    }

    public static SimpleHttpRequest patch(HttpHost host, String path) {
        Args.notNull((Object)host, (String)"Host");
        return new SimpleHttpRequest(StandardMethods.PATCH, host, path);
    }

    public static SimpleHttpRequest copy(HttpRequest original) {
        Args.notNull((Object)original, (String)"HTTP request");
        SimpleHttpRequest copy = new SimpleHttpRequest(original.getMethod(), original.getRequestUri());
        copy.setVersion(original.getVersion());
        Iterator it = original.headerIterator();
        while (it.hasNext()) {
            copy.addHeader((Header)it.next());
        }
        copy.setScheme(original.getScheme());
        copy.setAuthority(original.getAuthority());
        return copy;
    }

    public SimpleHttpRequest(String method, String path) {
        super(method, path);
    }

    public SimpleHttpRequest(String method, HttpHost host, String path) {
        super(method, host, path);
    }

    public SimpleHttpRequest(String method, URI requestUri) {
        super(method, requestUri);
    }

    SimpleHttpRequest(StandardMethods method, URI requestUri) {
        this(method.name(), requestUri);
    }

    SimpleHttpRequest(StandardMethods method, HttpHost host, String path) {
        this(method.name(), host, path);
    }

    public void setBody(SimpleBody body) {
        this.body = body;
    }

    public void setBodyBytes(byte[] bodyBytes, ContentType contentType) {
        this.body = SimpleBody.create(bodyBytes, contentType);
    }

    public void setBodyText(String bodyText, ContentType contentType) {
        this.body = SimpleBody.create(bodyText, contentType);
    }

    public SimpleBody getBody() {
        return this.body;
    }

    public ContentType getContentType() {
        return this.body != null ? this.body.getContentType() : null;
    }

    public String getBodyText() {
        return this.body != null ? this.body.getBodyText() : null;
    }

    public byte[] getBodyBytes() {
        return this.body != null ? this.body.getBodyBytes() : null;
    }
}

