/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.io.IOException;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpResponseFactory;
import org.apache.hc.core5.http.config.H1Config;
import org.apache.hc.core5.http.impl.io.DefaultHttpResponseParser;
import org.apache.hc.core5.http.message.LineParser;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LenientHttpResponseParser
extends DefaultHttpResponseParser {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());

    public LenientHttpResponseParser(LineParser lineParser, HttpResponseFactory<ClassicHttpResponse> responseFactory, H1Config h1Config) {
        super(lineParser, responseFactory, h1Config);
    }

    public LenientHttpResponseParser(H1Config h1Config) {
        this(null, null, h1Config);
    }

    protected ClassicHttpResponse createMessage(CharArrayBuffer buffer) throws IOException {
        try {
            return super.createMessage(buffer);
        }
        catch (HttpException ex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Garbage in response: " + buffer.toString());
            }
            return null;
        }
    }
}

