/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class SystemDefaultCredentialsProvider
implements CredentialsStore {
    private static final Map<String, String> SCHEME_MAP = new ConcurrentHashMap<String, String>();
    private final BasicCredentialsProvider internal = new BasicCredentialsProvider();

    private static String translateAuthScheme(String key) {
        if (key == null) {
            return null;
        }
        String s = SCHEME_MAP.get(key);
        return s != null ? s : key;
    }

    @Override
    public void setCredentials(AuthScope authscope, Credentials credentials) {
        this.internal.setCredentials(authscope, credentials);
    }

    private static PasswordAuthentication getSystemCreds(AuthScope authscope, Authenticator.RequestorType requestorType, HttpClientContext context) {
        URL targetHostURL;
        String hostname = authscope.getHost();
        int port = authscope.getPort();
        HttpHost origin = authscope.getOrigin();
        String protocol = origin != null ? origin.getSchemeName() : (port == 443 ? "https" : "http");
        HttpRequest request = context != null ? context.getRequest() : null;
        try {
            URI uri = request != null ? request.getUri() : null;
            targetHostURL = uri != null ? uri.toURL() : null;
        }
        catch (MalformedURLException | URISyntaxException ignore) {
            targetHostURL = null;
        }
        return Authenticator.requestPasswordAuthentication(hostname, null, port, protocol, authscope.getRealm(), SystemDefaultCredentialsProvider.translateAuthScheme(authscope.getScheme()), targetHostURL, requestorType);
    }

    @Override
    public Credentials getCredentials(AuthScope authscope, HttpContext context) {
        Args.notNull((Object)authscope, (String)"Auth scope");
        Credentials localcreds = this.internal.getCredentials(authscope, context);
        if (localcreds != null) {
            return localcreds;
        }
        String host = authscope.getHost();
        if (host != null) {
            String proxyPort;
            String proxyHost;
            HttpClientContext clientContext = context != null ? HttpClientContext.adapt(context) : null;
            PasswordAuthentication systemcreds = SystemDefaultCredentialsProvider.getSystemCreds(authscope, Authenticator.RequestorType.SERVER, clientContext);
            if (systemcreds == null) {
                systemcreds = SystemDefaultCredentialsProvider.getSystemCreds(authscope, Authenticator.RequestorType.PROXY, clientContext);
            }
            if (systemcreds == null && (proxyHost = System.getProperty("http.proxyHost")) != null && (proxyPort = System.getProperty("http.proxyPort")) != null) {
                try {
                    String proxyUser;
                    AuthScope systemScope = new AuthScope(proxyHost, Integer.parseInt(proxyPort));
                    if (authscope.match(systemScope) >= 0 && (proxyUser = System.getProperty("http.proxyUser")) != null) {
                        String proxyPassword = System.getProperty("http.proxyPassword");
                        systemcreds = new PasswordAuthentication(proxyUser, proxyPassword != null ? proxyPassword.toCharArray() : new char[]{});
                    }
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            if (systemcreds != null) {
                String domain = System.getProperty("http.auth.ntlm.domain");
                if (domain != null) {
                    return new NTCredentials(systemcreds.getUserName(), systemcreds.getPassword(), null, domain);
                }
                if ("NTLM".equalsIgnoreCase(authscope.getScheme())) {
                    return new NTCredentials(systemcreds.getUserName(), systemcreds.getPassword(), null, null);
                }
                return new UsernamePasswordCredentials(systemcreds.getUserName(), systemcreds.getPassword());
            }
        }
        return null;
    }

    @Override
    public void clear() {
        this.internal.clear();
    }

    static {
        SCHEME_MAP.put("Basic".toUpperCase(Locale.ROOT), "Basic");
        SCHEME_MAP.put("Digest".toUpperCase(Locale.ROOT), "Digest");
        SCHEME_MAP.put("NTLM".toUpperCase(Locale.ROOT), "NTLM");
        SCHEME_MAP.put("Negotiate".toUpperCase(Locale.ROOT), "SPNEGO");
        SCHEME_MAP.put("Kerberos".toUpperCase(Locale.ROOT), "Kerberos");
    }
}

