/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.async.AsyncExecRuntime;
import org.apache.hc.client5.http.auth.AuthSchemeProvider;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.CookieSpecProvider;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.async.AsyncExecChainElement;
import org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import org.apache.hc.client5.http.impl.async.InternalAbstractHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.InternalHttpAsyncExecRuntime;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.reactor.DefaultConnectingIOReactor;

class InternalHttpAsyncClient
extends InternalAbstractHttpAsyncClient {
    private final AsyncClientConnectionManager connmgr;
    private final HttpRoutePlanner routePlanner;
    private final HttpVersionPolicy versionPolicy;

    InternalHttpAsyncClient(DefaultConnectingIOReactor ioReactor, AsyncExecChainElement execChain, AsyncPushConsumerRegistry pushConsumerRegistry, ThreadFactory threadFactory, AsyncClientConnectionManager connmgr, HttpRoutePlanner routePlanner, HttpVersionPolicy versionPolicy, Lookup<CookieSpecProvider> cookieSpecRegistry, Lookup<AuthSchemeProvider> authSchemeRegistry, CookieStore cookieStore, CredentialsProvider credentialsProvider, RequestConfig defaultConfig, List<Closeable> closeables) {
        super(ioReactor, pushConsumerRegistry, threadFactory, execChain, cookieSpecRegistry, authSchemeRegistry, cookieStore, credentialsProvider, defaultConfig, closeables);
        this.connmgr = connmgr;
        this.routePlanner = routePlanner;
        this.versionPolicy = versionPolicy;
    }

    @Override
    AsyncExecRuntime crerateAsyncExecRuntime() {
        return new InternalHttpAsyncExecRuntime(this.log, this.connmgr, this.getConnectionInitiator(), this.versionPolicy);
    }

    @Override
    HttpRoute determineRoute(HttpRequest request, HttpClientContext clientContext) throws HttpException {
        HttpHost target = this.routePlanner.determineTargetHost(request, (HttpContext)clientContext);
        HttpRoute route = this.routePlanner.determineRoute(target, (HttpContext)clientContext);
        ProtocolVersion protocolVersion = clientContext.getProtocolVersion();
        if (route.isTunnelled() && protocolVersion.greaterEquals((ProtocolVersion)HttpVersion.HTTP_2_0)) {
            throw new HttpException("HTTP/2 tunneling not supported");
        }
        return route;
    }
}

