/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.RedirectException;
import org.apache.hc.client5.http.StandardMethods;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class AsyncRedirectExec
implements AsyncExecChainHandler {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final HttpRoutePlanner routePlanner;
    private final RedirectStrategy redirectStrategy;

    AsyncRedirectExec(HttpRoutePlanner routePlanner, RedirectStrategy redirectStrategy) {
        this.routePlanner = routePlanner;
        this.redirectStrategy = redirectStrategy;
    }

    private void internalExecute(final State state, final AsyncExecChain chain, final AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        final HttpRequest request = state.currentRequest;
        AsyncEntityProducer entityProducer = state.currentEntityProducer;
        final AsyncExecChain.Scope scope = state.currentScope;
        final HttpClientContext clientContext = scope.clientContext;
        final HttpRoute currentRoute = scope.route;
        chain.proceed(request, entityProducer, scope, new AsyncExecCallback(){

            @Override
            public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                state.redirectURI = null;
                RequestConfig config = clientContext.getRequestConfig();
                if (config.isRedirectsEnabled() && AsyncRedirectExec.this.redirectStrategy.isRedirected(request, response, (HttpContext)clientContext)) {
                    if (state.redirectCount >= state.maxRedirects) {
                        throw new RedirectException("Maximum redirects (" + state.maxRedirects + ") exceeded");
                    }
                    ++state.redirectCount;
                    URI redirectUri = AsyncRedirectExec.this.redirectStrategy.getLocationURI(request, response, (HttpContext)clientContext);
                    int statusCode = response.getCode();
                    switch (statusCode) {
                        case 301: 
                        case 302: 
                        case 303: {
                            if (!StandardMethods.isSafe(request.getMethod())) {
                                BasicHttpRequest httpGet = new BasicHttpRequest(StandardMethods.GET.name(), redirectUri);
                                httpGet.setHeaders(scope.originalRequest.getAllHeaders());
                                state.currentRequest = httpGet;
                                state.currentEntityProducer = null;
                                break;
                            }
                        }
                        default: {
                            state.currentRequest = new BasicHttpRequest(request.getMethod(), redirectUri);
                        }
                    }
                    HttpHost newTarget = URIUtils.extractHost(redirectUri);
                    if (newTarget == null) {
                        throw new ProtocolException("Redirect URI does not specify a valid host name: " + redirectUri);
                    }
                    if (!currentRoute.getTargetHost().equals((Object)newTarget)) {
                        AuthExchange proxyAuthExchange;
                        AuthScheme authScheme;
                        AsyncRedirectExec.this.log.debug("New route required");
                        state.reroute = true;
                        AuthExchange targetAuthExchange = clientContext.getAuthExchange(currentRoute.getTargetHost());
                        AsyncRedirectExec.this.log.debug("Resetting target auth state");
                        targetAuthExchange.reset();
                        if (currentRoute.getProxyHost() != null && (authScheme = (proxyAuthExchange = clientContext.getAuthExchange(currentRoute.getProxyHost())).getAuthScheme()) != null && authScheme.isConnectionBased()) {
                            AsyncRedirectExec.this.log.debug("Resetting proxy auth state");
                            proxyAuthExchange.reset();
                        }
                        HttpRoute newRoute = AsyncRedirectExec.this.routePlanner.determineRoute(newTarget, (HttpContext)clientContext);
                        state.currentScope = new AsyncExecChain.Scope(scope.exchangeId, newRoute, scope.originalRequest, clientContext, scope.execRuntime);
                        state.redirectURI = redirectUri;
                    } else {
                        state.reroute = false;
                        state.redirectURI = redirectUri;
                    }
                }
                if (state.redirectURI != null) {
                    if (AsyncRedirectExec.this.log.isDebugEnabled()) {
                        AsyncRedirectExec.this.log.debug(scope.exchangeId + ": redirecting to '" + state.redirectURI + "' via " + currentRoute);
                    }
                    return null;
                }
                return asyncExecCallback.handleResponse(response, entityDetails);
            }

            @Override
            public void completed() {
                if (state.redirectURI == null) {
                    asyncExecCallback.completed();
                } else {
                    AsyncEntityProducer entityProducer = state.currentEntityProducer;
                    if (entityProducer != null && !entityProducer.isRepeatable()) {
                        AsyncRedirectExec.this.log.debug("Cannot redirect non-repeatable request");
                        asyncExecCallback.completed();
                    } else {
                        try {
                            if (state.reroute) {
                                scope.execRuntime.releaseConnection();
                            }
                            AsyncRedirectExec.this.internalExecute(state, chain, asyncExecCallback);
                        }
                        catch (IOException | HttpException ex) {
                            asyncExecCallback.failed((Exception)ex);
                        }
                    }
                }
            }

            @Override
            public void failed(Exception cause) {
                asyncExecCallback.failed(cause);
            }
        });
    }

    @Override
    public void execute(HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        HttpClientContext clientContext = scope.clientContext;
        List<URI> redirectLocations = clientContext.getRedirectLocations();
        if (redirectLocations != null) {
            redirectLocations.clear();
        }
        RequestConfig config = clientContext.getRequestConfig();
        State state = new State();
        state.maxRedirects = config.getMaxRedirects() > 0 ? config.getMaxRedirects() : 50;
        state.redirectCount = 0;
        state.currentRequest = request;
        state.currentEntityProducer = entityProducer;
        state.currentScope = scope;
        this.internalExecute(state, chain, asyncExecCallback);
    }

    private static class State {
        volatile URI redirectURI;
        volatile int maxRedirects;
        volatile int redirectCount;
        volatile HttpRequest currentRequest;
        volatile AsyncEntityProducer currentEntityProducer;
        volatile AsyncExecChain.Scope currentScope;
        volatile boolean reroute;

        private State() {
        }
    }
}

