/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.impl.BasicHttpConnectionMetrics;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.http2.frame.DefaultFrameFactory;
import org.apache.hc.core5.http2.frame.FrameFactory;
import org.apache.hc.core5.http2.frame.StreamIdGenerator;
import org.apache.hc.core5.http2.impl.nio.AbstractHttp2StreamMultiplexer;
import org.apache.hc.core5.http2.impl.nio.ClientPushHttp2StreamHandler;
import org.apache.hc.core5.http2.impl.nio.Http2StreamChannel;
import org.apache.hc.core5.http2.impl.nio.Http2StreamHandler;
import org.apache.hc.core5.http2.impl.nio.Http2StreamListener;
import org.apache.hc.core5.net.InetAddressUtils;
import org.apache.hc.core5.reactor.TlsCapableIOSession;

public class ClientHttp2StreamMultiplexer
extends AbstractHttp2StreamMultiplexer {
    private final HandlerFactory<AsyncPushConsumer> pushHandlerFactory;

    public ClientHttp2StreamMultiplexer(TlsCapableIOSession ioSession, FrameFactory frameFactory, HttpProcessor httpProcessor, HandlerFactory<AsyncPushConsumer> pushHandlerFactory, H2Config h2Config, CharCodingConfig charCodingConfig, Http2StreamListener streamListener) {
        super(AbstractHttp2StreamMultiplexer.Mode.CLIENT, ioSession, frameFactory, StreamIdGenerator.ODD, httpProcessor, charCodingConfig, h2Config, streamListener);
        this.pushHandlerFactory = pushHandlerFactory;
    }

    public ClientHttp2StreamMultiplexer(TlsCapableIOSession ioSession, HttpProcessor httpProcessor, HandlerFactory<AsyncPushConsumer> pushHandlerFactory, H2Config h2Config, CharCodingConfig charCodingConfig) {
        this(ioSession, DefaultFrameFactory.INSTANCE, httpProcessor, pushHandlerFactory, h2Config, charCodingConfig, null);
    }

    public ClientHttp2StreamMultiplexer(TlsCapableIOSession ioSession, HttpProcessor httpProcessor, H2Config h2Config, CharCodingConfig charCodingConfig) {
        this(ioSession, httpProcessor, null, h2Config, charCodingConfig);
    }

    @Override
    Http2StreamHandler createRemotelyInitiatedStream(Http2StreamChannel channel, HttpProcessor httpProcessor, BasicHttpConnectionMetrics connMetrics) throws IOException {
        HttpCoreContext context = HttpCoreContext.create();
        context.setAttribute("http.ssl-ession", (Object)this.getSSLSession());
        context.setAttribute("http.connection-endpoint", (Object)this.getEndpointDetails());
        return new ClientPushHttp2StreamHandler(channel, httpProcessor, connMetrics, this.pushHandlerFactory, context);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        InetAddressUtils.formatAddress((StringBuilder)buffer, (SocketAddress)this.getLocalAddress());
        buffer.append("->");
        InetAddressUtils.formatAddress((StringBuilder)buffer, (SocketAddress)this.getRemoteAddress());
        return buffer.toString();
    }
}

