/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.ssl;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.reactor.ssl.SSLBufferManagement;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.Args;

public class BasicServerTlsStrategy
implements TlsStrategy {
    private final int[] securePorts;
    private final SSLContext sslContext;
    private final SSLBufferManagement sslBufferManagement;
    private final SSLSessionInitializer initializer;
    private final SSLSessionVerifier verifier;

    public BasicServerTlsStrategy(int[] securePorts, SSLContext sslContext, SSLBufferManagement sslBufferManagement, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        this.securePorts = Args.notNull(securePorts, "Array of ports");
        this.sslContext = Args.notNull(sslContext, "SSL context");
        this.sslBufferManagement = sslBufferManagement;
        this.initializer = initializer;
        this.verifier = verifier;
    }

    public BasicServerTlsStrategy(int[] securePorts, SSLContext sslContext, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        this(securePorts, sslContext, null, initializer, verifier);
    }

    public BasicServerTlsStrategy(int[] securePorts, SSLContext sslContext, SSLSessionVerifier verifier) {
        this(securePorts, sslContext, null, null, verifier);
    }

    public BasicServerTlsStrategy(int[] securePorts, SSLContext sslContext) {
        this(securePorts, sslContext, null, null, null);
    }

    public BasicServerTlsStrategy(int[] securePorts) {
        this(securePorts, SSLContexts.createSystemDefault());
    }

    @Override
    public boolean upgrade(TransportSecurityLayer tlsSession, HttpHost host, SocketAddress localAddress, SocketAddress remoteAddress, Object attachment) {
        int port = ((InetSocketAddress)localAddress).getPort();
        for (int securePort : this.securePorts) {
            if (port != securePort) continue;
            tlsSession.startTls(this.sslContext, this.sslBufferManagement, this.initializer, this.verifier);
            return true;
        }
        return false;
    }
}

