/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.async.methods.SimpleBody;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.cache.CacheResponseStatus;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.HttpCacheStorage;
import org.apache.hc.client5.http.cache.ResourceFactory;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.impl.cache.BasicHttpCache;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CacheValidityPolicy;
import org.apache.hc.client5.http.impl.cache.CacheableRequestPolicy;
import org.apache.hc.client5.http.impl.cache.CachedHttpResponseGenerator;
import org.apache.hc.client5.http.impl.cache.CachedResponseSuitabilityChecker;
import org.apache.hc.client5.http.impl.cache.CachingExecBase;
import org.apache.hc.client5.http.impl.cache.CombinedEntity;
import org.apache.hc.client5.http.impl.cache.ConditionalRequestBuilder;
import org.apache.hc.client5.http.impl.cache.HttpCache;
import org.apache.hc.client5.http.impl.cache.RequestProtocolCompliance;
import org.apache.hc.client5.http.impl.cache.ResponseCachingPolicy;
import org.apache.hc.client5.http.impl.cache.ResponseProtocolCompliance;
import org.apache.hc.client5.http.impl.cache.Variant;
import org.apache.hc.client5.http.impl.classic.ClassicRequestCopier;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Contract(threading=ThreadingBehavior.SAFE)
public class CachingExec
extends CachingExecBase
implements ExecChainHandler {
    private final ConditionalRequestBuilder<ClassicHttpRequest> conditionalRequestBuilder;
    private final Logger log = LogManager.getLogger(this.getClass());

    public CachingExec(HttpCache cache, CacheConfig config) {
        super(cache, config);
        this.conditionalRequestBuilder = new ConditionalRequestBuilder(ClassicRequestCopier.INSTANCE);
    }

    public CachingExec(ResourceFactory resourceFactory, HttpCacheStorage storage, CacheConfig config) {
        this(new BasicHttpCache(resourceFactory, storage), config);
    }

    public CachingExec() {
        this(new BasicHttpCache(), CacheConfig.DEFAULT);
    }

    CachingExec(HttpCache responseCache, CacheValidityPolicy validityPolicy, ResponseCachingPolicy responseCachingPolicy, CachedHttpResponseGenerator responseGenerator, CacheableRequestPolicy cacheableRequestPolicy, CachedResponseSuitabilityChecker suitabilityChecker, ConditionalRequestBuilder<ClassicHttpRequest> conditionalRequestBuilder, ResponseProtocolCompliance responseCompliance, RequestProtocolCompliance requestCompliance, CacheConfig config) {
        super(responseCache, validityPolicy, responseCachingPolicy, responseGenerator, cacheableRequestPolicy, suitabilityChecker, responseCompliance, requestCompliance, config);
        this.conditionalRequestBuilder = conditionalRequestBuilder;
    }

    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)scope, (String)"Scope");
        HttpRoute route = scope.route;
        HttpClientContext context = scope.clientContext;
        context.setAttribute("http.route", (Object)scope.route);
        context.setAttribute("http.request", (Object)request);
        URIAuthority authority = request.getAuthority();
        String scheme = request.getScheme();
        HttpHost target = authority != null ? new HttpHost((NamedEndpoint)authority, scheme) : route.getTargetHost();
        String via = this.generateViaHeader((HttpMessage)request);
        this.setResponseStatus((HttpContext)context, CacheResponseStatus.CACHE_MISS);
        if (this.clientRequestsOurOptions((HttpRequest)request)) {
            this.setResponseStatus((HttpContext)context, CacheResponseStatus.CACHE_MODULE_RESPONSE);
            return new BasicClassicHttpResponse(501);
        }
        SimpleHttpResponse fatalErrorResponse = this.getFatallyNoncompliantResponse((HttpRequest)request, (HttpContext)context);
        if (fatalErrorResponse != null) {
            return CachingExec.convert(fatalErrorResponse);
        }
        this.requestCompliance.makeRequestCompliant((HttpRequest)request);
        request.addHeader("Via", (Object)via);
        if (!this.cacheableRequestPolicy.isServableFromCache((HttpRequest)request)) {
            this.log.debug("Request is not servable from cache");
            this.flushEntriesInvalidatedByRequest(target, (HttpRequest)request);
            return this.callBackend(target, request, scope, chain);
        }
        HttpCacheEntry entry = this.satisfyFromCache(target, (HttpRequest)request);
        if (entry == null) {
            this.log.debug("Cache miss");
            return this.handleCacheMiss(target, request, scope, chain);
        }
        return this.handleCacheHit(target, request, scope, chain, entry);
    }

    private static ClassicHttpResponse convert(SimpleHttpResponse cacheResponse) {
        if (cacheResponse == null) {
            return null;
        }
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(cacheResponse.getCode(), cacheResponse.getReasonPhrase());
        Iterator it = cacheResponse.headerIterator();
        while (it.hasNext()) {
            response.addHeader((Header)it.next());
        }
        response.setVersion((ProtocolVersion)(cacheResponse.getVersion() != null ? cacheResponse.getVersion() : HttpVersion.DEFAULT));
        SimpleBody body = cacheResponse.getBody();
        if (body != null) {
            if (body.isText()) {
                response.setEntity((HttpEntity)new StringEntity(body.getBodyText(), body.getContentType()));
            } else {
                response.setEntity((HttpEntity)new ByteArrayEntity(body.getBodyBytes(), body.getContentType()));
            }
        }
        return response;
    }

    ClassicHttpResponse callBackend(HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        Date requestDate = this.getCurrentDate();
        this.log.debug("Calling the backend");
        ClassicHttpResponse backendResponse = chain.proceed(request, scope);
        try {
            backendResponse.addHeader("Via", (Object)this.generateViaHeader((HttpMessage)backendResponse));
            return this.handleBackendResponse(target, request, scope, requestDate, this.getCurrentDate(), backendResponse);
        }
        catch (IOException | RuntimeException ex) {
            backendResponse.close();
            throw ex;
        }
    }

    private ClassicHttpResponse handleCacheHit(HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain, HttpCacheEntry entry) throws IOException, HttpException {
        HttpClientContext context = scope.clientContext;
        context.setAttribute("http.request", (Object)request);
        this.recordCacheHit(target, (HttpRequest)request);
        Date now = this.getCurrentDate();
        if (this.suitabilityChecker.canCachedResponseBeUsed(target, (HttpRequest)request, entry, now)) {
            this.log.debug("Cache hit");
            try {
                ClassicHttpResponse response = CachingExec.convert(this.generateCachedResponse((HttpRequest)request, (HttpContext)context, entry, now));
                context.setAttribute("http.response", (Object)response);
                return response;
            }
            catch (ResourceIOException ex) {
                this.recordCacheFailure(target, (HttpRequest)request);
                if (!this.mayCallBackend((HttpRequest)request)) {
                    ClassicHttpResponse response = CachingExec.convert(this.generateGatewayTimeout((HttpContext)context));
                    context.setAttribute("http.response", (Object)response);
                    return response;
                }
                this.setResponseStatus((HttpContext)scope.clientContext, CacheResponseStatus.FAILURE);
                return chain.proceed(request, scope);
            }
        }
        if (!this.mayCallBackend((HttpRequest)request)) {
            this.log.debug("Cache entry not suitable but only-if-cached requested");
            ClassicHttpResponse response = CachingExec.convert(this.generateGatewayTimeout((HttpContext)context));
            context.setAttribute("http.response", (Object)response);
            return response;
        }
        if (entry.getStatus() != 304 || this.suitabilityChecker.isConditional((HttpRequest)request)) {
            this.log.debug("Revalidating cache entry");
            try {
                return this.revalidateCacheEntry(target, request, scope, chain, entry);
            }
            catch (IOException ioex) {
                return CachingExec.convert(this.handleRevalidationFailure((HttpRequest)request, (HttpContext)context, entry, now));
            }
        }
        this.log.debug("Cache entry not usable; calling backend");
        return this.callBackend(target, request, scope, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ClassicHttpResponse revalidateCacheEntry(HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain, HttpCacheEntry cacheEntry) throws IOException, HttpException {
        ClassicHttpResponse classicHttpResponse;
        ClassicHttpRequest conditionalRequest = this.conditionalRequestBuilder.buildConditionalRequest(scope.originalRequest, cacheEntry);
        Date requestDate = this.getCurrentDate();
        ClassicHttpResponse backendResponse = chain.proceed(conditionalRequest, scope);
        Date responseDate = this.getCurrentDate();
        if (this.revalidationResponseIsTooOld((HttpResponse)backendResponse, cacheEntry)) {
            backendResponse.close();
            ClassicHttpRequest unconditional = this.conditionalRequestBuilder.buildUnconditionalRequest(scope.originalRequest);
            requestDate = this.getCurrentDate();
            backendResponse = chain.proceed(unconditional, scope);
            responseDate = this.getCurrentDate();
        }
        backendResponse.addHeader("Via", (Object)this.generateViaHeader((HttpMessage)backendResponse));
        int statusCode = backendResponse.getCode();
        if (statusCode == 304 || statusCode == 200) {
            this.recordCacheUpdate((HttpContext)scope.clientContext);
        }
        if (statusCode == 304) {
            HttpCacheEntry updatedEntry = this.responseCache.updateCacheEntry(target, (HttpRequest)request, cacheEntry, (HttpResponse)backendResponse, requestDate, responseDate);
            if (!this.suitabilityChecker.isConditional((HttpRequest)request) || !this.suitabilityChecker.allConditionalsMatch((HttpRequest)request, updatedEntry, new Date())) return CachingExec.convert(this.responseGenerator.generateResponse((HttpRequest)request, updatedEntry));
            return CachingExec.convert(this.responseGenerator.generateNotModifiedResponse(updatedEntry));
        }
        if (!this.staleIfErrorAppliesTo(statusCode) || this.staleResponseNotAllowed((HttpRequest)request, cacheEntry, this.getCurrentDate()) || !this.validityPolicy.mayReturnStaleIfError((HttpRequest)request, cacheEntry, responseDate)) return this.handleBackendResponse(target, conditionalRequest, scope, requestDate, responseDate, backendResponse);
        try {
            SimpleHttpResponse cachedResponse = this.responseGenerator.generateResponse((HttpRequest)request, cacheEntry);
            cachedResponse.addHeader("Warning", (Object)"110 localhost \"Response is stale\"");
            classicHttpResponse = CachingExec.convert(cachedResponse);
        }
        catch (Throwable throwable) {
            try {
                backendResponse.close();
                throw throwable;
            }
            catch (IOException | RuntimeException ex) {
                backendResponse.close();
                throw ex;
            }
        }
        backendResponse.close();
        return classicHttpResponse;
    }

    ClassicHttpResponse handleBackendResponse(HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, Date requestDate, Date responseDate, ClassicHttpResponse backendResponse) throws IOException {
        this.responseCompliance.ensureProtocolCompliance((HttpRequest)scope.originalRequest, (HttpRequest)request, (HttpResponse)backendResponse);
        boolean cacheable = this.responseCachingPolicy.isResponseCacheable((HttpRequest)request, (HttpResponse)backendResponse);
        this.responseCache.flushInvalidatedCacheEntriesFor(target, (HttpRequest)request, (HttpResponse)backendResponse);
        if (cacheable && !this.alreadyHaveNewerCacheEntry(target, (HttpRequest)request, (HttpResponse)backendResponse)) {
            this.storeRequestIfModifiedSinceFor304Response((HttpRequest)request, (HttpResponse)backendResponse);
            return this.cacheAndReturnResponse(target, (HttpRequest)request, backendResponse, requestDate, responseDate);
        }
        if (!cacheable) {
            this.log.debug("Backend response is not cacheable");
            try {
                this.responseCache.flushCacheEntriesFor(target, (HttpRequest)request);
            }
            catch (IOException ioe) {
                this.log.warn("Unable to flush invalid cache entries", (Throwable)ioe);
            }
        }
        return backendResponse;
    }

    ClassicHttpResponse cacheAndReturnResponse(HttpHost target, HttpRequest request, ClassicHttpResponse backendResponse, Date requestSent, Date responseReceived) throws IOException {
        ByteArrayBuffer buf;
        this.log.debug("Caching backend response");
        HttpEntity entity = backendResponse.getEntity();
        if (entity != null) {
            int l;
            buf = new ByteArrayBuffer(1024);
            InputStream instream = entity.getContent();
            byte[] tmp = new byte[2048];
            long total = 0L;
            while ((l = instream.read(tmp)) != -1) {
                buf.append(tmp, 0, l);
                if ((total += (long)l) <= this.cacheConfig.getMaxObjectSize()) continue;
                this.log.debug("Backend response content length exceeds maximum");
                backendResponse.setEntity((HttpEntity)new CombinedEntity(entity, buf));
                return backendResponse;
            }
        } else {
            buf = null;
        }
        backendResponse.close();
        HttpCacheEntry entry = this.responseCache.createCacheEntry(target, request, (HttpResponse)backendResponse, buf, requestSent, responseReceived);
        this.log.debug("Backend response successfully cached");
        return CachingExec.convert(this.responseGenerator.generateResponse(request, entry));
    }

    private ClassicHttpResponse handleCacheMiss(HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        this.recordCacheMiss(target, (HttpRequest)request);
        if (!this.mayCallBackend((HttpRequest)request)) {
            return new BasicClassicHttpResponse(504, "Gateway Timeout");
        }
        Map<String, Variant> variants = this.getExistingCacheVariants(target, (HttpRequest)request);
        if (variants != null && !variants.isEmpty()) {
            return this.negotiateResponseFromVariants(target, request, scope, chain, variants);
        }
        return this.callBackend(target, request, scope, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassicHttpResponse negotiateResponseFromVariants(HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain, Map<String, Variant> variants) throws IOException, HttpException {
        ClassicHttpRequest conditionalRequest = this.conditionalRequestBuilder.buildConditionalRequestFromVariants(request, variants);
        Date requestDate = this.getCurrentDate();
        ClassicHttpResponse backendResponse = chain.proceed(conditionalRequest, scope);
        try {
            Date responseDate = this.getCurrentDate();
            backendResponse.addHeader("Via", (Object)this.generateViaHeader((HttpMessage)backendResponse));
            if (backendResponse.getCode() != 304) {
                return this.handleBackendResponse(target, request, scope, requestDate, responseDate, backendResponse);
            }
            Header resultEtagHeader = backendResponse.getFirstHeader("ETag");
            if (resultEtagHeader == null) {
                this.log.warn("304 response did not contain ETag");
                EntityUtils.consume((HttpEntity)backendResponse.getEntity());
                backendResponse.close();
                return this.callBackend(target, request, scope, chain);
            }
            String resultEtag = resultEtagHeader.getValue();
            Variant matchingVariant = variants.get(resultEtag);
            if (matchingVariant == null) {
                this.log.debug("304 response did not contain ETag matching one sent in If-None-Match");
                EntityUtils.consume((HttpEntity)backendResponse.getEntity());
                backendResponse.close();
                return this.callBackend(target, request, scope, chain);
            }
            HttpCacheEntry matchedEntry = matchingVariant.getEntry();
            if (this.revalidationResponseIsTooOld((HttpResponse)backendResponse, matchedEntry)) {
                EntityUtils.consume((HttpEntity)backendResponse.getEntity());
                backendResponse.close();
                ClassicHttpRequest unconditional = this.conditionalRequestBuilder.buildUnconditionalRequest(request);
                return this.callBackend(target, unconditional, scope, chain);
            }
            this.recordCacheUpdate((HttpContext)scope.clientContext);
            HttpCacheEntry responseEntry = matchedEntry;
            try {
                responseEntry = this.responseCache.updateVariantCacheEntry(target, (HttpRequest)conditionalRequest, matchedEntry, (HttpResponse)backendResponse, requestDate, responseDate, matchingVariant.getCacheKey());
            }
            catch (IOException ioe) {
                this.log.warn("Could not processChallenge cache entry", (Throwable)ioe);
            }
            finally {
                backendResponse.close();
            }
            if (this.shouldSendNotModifiedResponse((HttpRequest)request, responseEntry)) {
                return CachingExec.convert(this.responseGenerator.generateNotModifiedResponse(responseEntry));
            }
            SimpleHttpResponse resp = this.responseGenerator.generateResponse((HttpRequest)request, responseEntry);
            this.tryToUpdateVariantMap(target, (HttpRequest)request, matchingVariant);
            return CachingExec.convert(resp);
        }
        catch (IOException | RuntimeException ex) {
            backendResponse.close();
            throw ex;
        }
    }
}

