/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.impl.cache.AsynchronousValidator;
import org.apache.hc.client5.http.impl.cache.CachingExec;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AsynchronousValidationRequest
implements Runnable {
    private final AsynchronousValidator parent;
    private final CachingExec cachingExec;
    private final HttpHost target;
    private final ClassicHttpRequest request;
    private final ExecChain.Scope scope;
    private final ExecChain chain;
    private final HttpCacheEntry cacheEntry;
    private final String identifier;
    private final int consecutiveFailedAttempts;
    private final Logger log = LogManager.getLogger(this.getClass());

    AsynchronousValidationRequest(AsynchronousValidator parent, CachingExec cachingExec, HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain, HttpCacheEntry cacheEntry, String identifier, int consecutiveFailedAttempts) {
        this.parent = parent;
        this.cachingExec = cachingExec;
        this.target = target;
        this.request = request;
        this.scope = scope;
        this.chain = chain;
        this.cacheEntry = cacheEntry;
        this.identifier = identifier;
        this.consecutiveFailedAttempts = consecutiveFailedAttempts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.revalidateCacheEntry()) {
                this.parent.jobSuccessful(this.identifier);
            } else {
                this.parent.jobFailed(this.identifier);
            }
        }
        finally {
            this.parent.markComplete(this.identifier);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean revalidateCacheEntry() {
        try (ClassicHttpResponse httpResponse = this.cachingExec.revalidateCacheEntry(this.target, this.request, this.scope, this.chain, this.cacheEntry);){
            int statusCode = httpResponse.getCode();
            boolean bl = this.isNotServerError(statusCode) && this.isNotStale((HttpResponse)httpResponse);
            return bl;
        }
        catch (IOException ioe) {
            this.log.debug("Asynchronous revalidation failed due to I/O error", (Throwable)ioe);
            return false;
        }
        catch (HttpException pe) {
            this.log.error("HTTP protocol exception during asynchronous revalidation", (Throwable)pe);
            return false;
        }
        catch (RuntimeException re) {
            this.log.error("RuntimeException thrown during asynchronous revalidation: " + re);
            return false;
        }
    }

    private boolean isNotServerError(int statusCode) {
        return statusCode < 500;
    }

    private boolean isNotStale(HttpResponse httpResponse) {
        Header[] warnings = httpResponse.getHeaders("Warning");
        if (warnings != null) {
            for (Header warning : warnings) {
                String warningValue = warning.getValue();
                if (!warningValue.startsWith("110") && !warningValue.startsWith("111")) continue;
                return false;
            }
        }
        return true;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getConsecutiveFailedAttempts() {
        return this.consecutiveFailedAttempts;
    }
}

