/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.nio;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.command.ExecutionCommand;
import org.apache.hc.core5.http.nio.command.ShutdownCommand;
import org.apache.hc.core5.http.nio.support.BasicClientExchangeHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.GracefullyCloseable;
import org.apache.hc.core5.io.ShutdownType;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Asserts;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public final class ClientSessionEndpoint
implements GracefullyCloseable {
    private final IOSession ioSession;
    private final AtomicBoolean closed;

    public ClientSessionEndpoint(IOSession ioSession) {
        this.ioSession = ioSession;
        this.closed = new AtomicBoolean(false);
    }

    public void execute(Command command) {
        this.ioSession.addLast(command);
        if (this.ioSession.isClosed()) {
            command.cancel();
        }
    }

    public void execute(AsyncClientExchangeHandler exchangeHandler, HttpContext context) {
        Asserts.check((!this.closed.get() ? 1 : 0) != 0, (String)"Connection is already closed");
        ExecutionCommand executionCommand = new ExecutionCommand(exchangeHandler, context);
        this.execute((Command)executionCommand);
    }

    public <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        Asserts.check((!this.closed.get() ? 1 : 0) != 0, (String)"Connection is already closed");
        final BasicFuture future = new BasicFuture(callback);
        this.execute((AsyncClientExchangeHandler)new BasicClientExchangeHandler(requestProducer, responseConsumer, new FutureCallback<T>(){

            public void completed(T result) {
                future.completed(result);
            }

            public void failed(Exception ex) {
                future.failed(ex);
            }

            public void cancelled() {
                future.cancel();
            }
        }), context);
        return future;
    }

    public <T> Future<T> execute(AsyncRequestProducer requestProducer, AsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback) {
        return this.execute(requestProducer, responseConsumer, null, callback);
    }

    public boolean isOpen() {
        return !this.closed.get() && !this.ioSession.isClosed();
    }

    public void shutdown(ShutdownType shutdownType) {
        if (this.closed.compareAndSet(false, true)) {
            if (shutdownType == ShutdownType.GRACEFUL) {
                this.ioSession.addFirst((Command)new ShutdownCommand(ShutdownType.GRACEFUL));
            } else {
                this.ioSession.shutdown(shutdownType);
            }
        }
    }

    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.ioSession.addFirst((Command)new ShutdownCommand(ShutdownType.GRACEFUL));
        }
    }

    public String toString() {
        return this.ioSession.toString();
    }
}

