/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.sync.methods;

import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.CancellableAware;
import org.apache.hc.client5.http.config.Configurable;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;

public class HttpUriRequestBase
extends BasicClassicHttpRequest
implements CancellableAware,
Configurable {
    private static final long serialVersionUID = 1L;
    private RequestConfig requestConfig;
    private final AtomicBoolean aborted = new AtomicBoolean(false);
    private final AtomicReference<Cancellable> cancellableRef = new AtomicReference<Object>(null);

    public HttpUriRequestBase(String method, URI requestUri) {
        super(method, requestUri);
    }

    public void abort() {
        Cancellable cancellable;
        if (this.aborted.compareAndSet(false, true) && (cancellable = (Cancellable)this.cancellableRef.getAndSet(null)) != null) {
            cancellable.cancel();
        }
    }

    @Override
    public boolean isCancelled() {
        return this.isAborted();
    }

    public boolean isAborted() {
        return this.aborted.get();
    }

    @Override
    public void setCancellable(Cancellable cancellable) {
        if (!this.aborted.get()) {
            this.cancellableRef.set(cancellable);
        }
    }

    public void reset() {
        Cancellable cancellable = this.cancellableRef.getAndSet(null);
        if (cancellable != null) {
            cancellable.cancel();
        }
        this.aborted.set(false);
    }

    public void setConfig(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
    }

    @Override
    public RequestConfig getConfig() {
        return this.requestConfig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMethod()).append(" ").append(this.getRequestUri());
        return sb.toString();
    }
}

