/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.ssl;

import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import org.apache.hc.client5.http.psl.PublicSuffixMatcherLoader;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.HttpClientHostnameVerifier;
import org.apache.hc.client5.http.ssl.SubjectName;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.http2.ssl.H2TlsSupport;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.ssl.SSLBufferManagement;
import org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class H2TlsStrategy
implements TlsStrategy {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final SSLContext sslContext;
    private final String[] supportedProtocols;
    private final String[] supportedCipherSuites;
    private final SSLBufferManagement sslBufferManagement;
    private final HostnameVerifier hostnameVerifier;

    private static String[] split(String s) {
        if (TextUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return s.split(" *, *");
    }

    public static HostnameVerifier getDefaultHostnameVerifier() {
        return new DefaultHostnameVerifier(PublicSuffixMatcherLoader.getDefault());
    }

    public static TlsStrategy getDefault() {
        return new H2TlsStrategy(SSLContexts.createDefault(), H2TlsStrategy.getDefaultHostnameVerifier());
    }

    public static TlsStrategy getSystemDefault() {
        return new H2TlsStrategy(SSLContexts.createSystemDefault(), H2TlsStrategy.split(System.getProperty("https.protocols")), H2TlsStrategy.split(System.getProperty("https.cipherSuites")), SSLBufferManagement.STATIC, H2TlsStrategy.getDefaultHostnameVerifier());
    }

    public H2TlsStrategy(SSLContext sslContext, String[] supportedProtocols, String[] supportedCipherSuites, SSLBufferManagement sslBufferManagement, HostnameVerifier hostnameVerifier) {
        this.sslContext = (SSLContext)Args.notNull((Object)sslContext, (String)"SSL context");
        this.supportedProtocols = supportedProtocols;
        this.supportedCipherSuites = supportedCipherSuites;
        this.sslBufferManagement = sslBufferManagement != null ? sslBufferManagement : SSLBufferManagement.STATIC;
        this.hostnameVerifier = hostnameVerifier != null ? hostnameVerifier : H2TlsStrategy.getDefaultHostnameVerifier();
    }

    public H2TlsStrategy(SSLContext sslcontext, HostnameVerifier hostnameVerifier) {
        this(sslcontext, null, null, SSLBufferManagement.STATIC, hostnameVerifier);
    }

    public H2TlsStrategy(SSLContext sslcontext) {
        this(sslcontext, H2TlsStrategy.getDefaultHostnameVerifier());
    }

    public boolean upgrade(TransportSecurityLayer tlsSession, HttpHost host, SocketAddress localAddress, SocketAddress remoteAddress, Object attachment) {
        tlsSession.startTls(this.sslContext, this.sslBufferManagement, H2TlsSupport.enforceRequirements((Object)attachment, (SSLSessionInitializer)new SSLSessionInitializer(){

            public void initialize(NamedEndpoint endpoint, SSLEngine sslEngine) {
                if (H2TlsStrategy.this.supportedProtocols != null) {
                    sslEngine.setEnabledProtocols(H2TlsStrategy.this.supportedProtocols);
                }
                if (H2TlsStrategy.this.supportedCipherSuites != null) {
                    sslEngine.setEnabledCipherSuites(H2TlsStrategy.this.supportedCipherSuites);
                }
                H2TlsStrategy.this.initializeEngine(sslEngine);
                if (H2TlsStrategy.this.log.isDebugEnabled()) {
                    H2TlsStrategy.this.log.debug("Enabled protocols: " + Arrays.asList(sslEngine.getEnabledProtocols()));
                    H2TlsStrategy.this.log.debug("Enabled cipher suites:" + Arrays.asList(sslEngine.getEnabledCipherSuites()));
                }
            }
        }), new SSLSessionVerifier(){

            public TlsDetails verify(NamedEndpoint endpoint, SSLEngine sslEngine) throws SSLException {
                H2TlsStrategy.this.verifySession(endpoint.getHostName(), sslEngine.getSession());
                return H2TlsStrategy.this.createTlsDetails(sslEngine);
            }
        });
        return true;
    }

    protected void initializeEngine(SSLEngine sslEngine) {
    }

    protected void verifySession(String hostname, SSLSession sslsession) throws SSLException {
        X509Certificate x509;
        Certificate[] certs;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Secure session established");
            this.log.debug(" negotiated protocol: " + sslsession.getProtocol());
            this.log.debug(" negotiated cipher suite: " + sslsession.getCipherSuite());
            try {
                certs = sslsession.getPeerCertificates();
                x509 = (X509Certificate)certs[0];
                X500Principal peer = x509.getSubjectX500Principal();
                this.log.debug(" peer principal: " + peer.toString());
                Collection<List<?>> altNames1 = x509.getSubjectAlternativeNames();
                if (altNames1 != null) {
                    ArrayList<String> altNames = new ArrayList<String>();
                    for (List<?> aC : altNames1) {
                        if (aC.isEmpty()) continue;
                        altNames.add((String)aC.get(1));
                    }
                    this.log.debug(" peer alternative names: " + altNames);
                }
                X500Principal issuer = x509.getIssuerX500Principal();
                this.log.debug(" issuer principal: " + issuer.toString());
                Collection<List<?>> altNames2 = x509.getIssuerAlternativeNames();
                if (altNames2 != null) {
                    ArrayList<String> altNames = new ArrayList<String>();
                    for (List<?> aC : altNames2) {
                        if (aC.isEmpty()) continue;
                        altNames.add((String)aC.get(1));
                    }
                    this.log.debug(" issuer alternative names: " + altNames);
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (this.hostnameVerifier instanceof HttpClientHostnameVerifier) {
            certs = sslsession.getPeerCertificates();
            x509 = (X509Certificate)certs[0];
            ((HttpClientHostnameVerifier)this.hostnameVerifier).verify(hostname, x509);
        } else if (!this.hostnameVerifier.verify(hostname, sslsession)) {
            certs = sslsession.getPeerCertificates();
            x509 = (X509Certificate)certs[0];
            List<SubjectName> subjectAlts = DefaultHostnameVerifier.getSubjectAltNames(x509);
            throw new SSLPeerUnverifiedException("Certificate for <" + hostname + "> doesn't match any " + "of the subject alternative names: " + subjectAlts);
        }
    }

    protected TlsDetails createTlsDetails(SSLEngine sslEngine) {
        return null;
    }
}

