/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.osgi.impl;

import java.util.List;
import org.apache.hc.client5.http.impl.routing.DefaultRoutePlanner;
import org.apache.hc.client5.http.osgi.impl.HostMatcher;
import org.apache.hc.client5.http.osgi.services.ProxyConfiguration;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;

final class OSGiHttpRoutePlanner
extends DefaultRoutePlanner {
    private final List<ProxyConfiguration> proxyConfigurations;

    public OSGiHttpRoutePlanner(List<ProxyConfiguration> proxyConfigurations) {
        super(null);
        this.proxyConfigurations = proxyConfigurations;
    }

    @Override
    protected HttpHost determineProxy(HttpHost target, HttpContext context) throws HttpException {
        HttpHost proxyHost = null;
        for (ProxyConfiguration proxyConfiguration : this.proxyConfigurations) {
            if (!proxyConfiguration.isEnabled()) continue;
            for (String exception : proxyConfiguration.getProxyExceptions()) {
                if (!HostMatcher.HostMatcherFactory.createMatcher(exception).matches(target.getHostName())) continue;
                return null;
            }
            if (null != proxyHost) continue;
            proxyHost = new HttpHost(proxyConfiguration.getHostname(), proxyConfiguration.getPort());
        }
        return proxyHost;
    }
}

