/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.osgi.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.hc.client5.http.impl.sync.CloseableHttpClient;
import org.apache.hc.client5.http.osgi.impl.HttpClientBuilderConfigurator;
import org.apache.hc.client5.http.osgi.impl.OSGiCachingClientBuilderFactory;
import org.apache.hc.client5.http.osgi.impl.OSGiClientBuilderFactory;
import org.apache.hc.client5.http.osgi.impl.OSGiProxyConfiguration;
import org.apache.hc.client5.http.osgi.impl.OSGiTrustedHostsConfiguration;
import org.apache.hc.client5.http.osgi.impl.WeakList;
import org.apache.hc.client5.http.osgi.services.CachingHttpClientBuilderFactory;
import org.apache.hc.client5.http.osgi.services.HttpClientBuilderFactory;
import org.apache.hc.client5.http.osgi.services.ProxyConfiguration;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;

public final class HttpProxyConfigurationActivator
implements BundleActivator,
ManagedServiceFactory {
    private static final String PROXY_SERVICE_FACTORY_NAME = "Apache HTTP Client Proxy Configuration Factory";
    private static final String PROXY_SERVICE_PID = "org.apache.hc.client5.http.proxyconfigurator";
    private static final String TRUSTED_HOSTS_SERVICE_NAME = "Apache HTTP Client Trusted Hosts Configuration";
    private static final String TRUSTED_HOSTS_PID = "org.apache.hc.client5.http.trustedhosts";
    private static final String BUILDER_FACTORY_SERVICE_NAME = "Apache HTTP Client Client Factory";
    private static final String BUILDER_FACTORY_SERVICE_PID = "org.apache.hc.client5.http.httpclientfactory";
    private static final String CACHEABLE_BUILDER_FACTORY_SERVICE_NAME = "Apache HTTP Client Caching Client Factory";
    private static final String CACHEABLE_BUILDER_FACTORY_SERVICE_PID = "org.apache.hc.client5.http.cachinghttpclientfactory";
    private ServiceRegistration<ManagedServiceFactory> configurator;
    private ServiceRegistration<ManagedService> trustedHostConfiguration;
    private ServiceRegistration<HttpClientBuilderFactory> clientFactory;
    private ServiceRegistration<CachingHttpClientBuilderFactory> cachingClientFactory;
    private BundleContext context;
    private final Map<String, ServiceRegistration<ProxyConfiguration>> registeredConfigurations = new LinkedHashMap<String, ServiceRegistration<ProxyConfiguration>>();
    private final List<ProxyConfiguration> proxyConfigurations = new CopyOnWriteArrayList<ProxyConfiguration>();
    private final HttpClientTracker httpClientTracker = new HttpClientTracker();

    public void start(BundleContext context) throws Exception {
        this.context = context;
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.pid", this.getName());
        props.put("service.vendor", (String)context.getBundle().getHeaders().get("Bundle-Vendor"));
        props.put("service.description", PROXY_SERVICE_FACTORY_NAME);
        this.configurator = context.registerService(ManagedServiceFactory.class, (Object)this, props);
        props.clear();
        props.put("service.pid", TRUSTED_HOSTS_PID);
        props.put("service.vendor", (String)context.getBundle().getHeaders().get("Bundle-Vendor"));
        props.put("service.description", TRUSTED_HOSTS_SERVICE_NAME);
        OSGiTrustedHostsConfiguration trustedHosts = new OSGiTrustedHostsConfiguration();
        this.trustedHostConfiguration = context.registerService(ManagedService.class, (Object)trustedHosts, props);
        HttpClientBuilderConfigurator configurator = new HttpClientBuilderConfigurator(this.proxyConfigurations, trustedHosts);
        props.clear();
        props.put("service.pid", BUILDER_FACTORY_SERVICE_PID);
        props.put("service.vendor", (String)context.getBundle().getHeaders().get("Bundle-Vendor"));
        props.put("service.description", BUILDER_FACTORY_SERVICE_NAME);
        this.clientFactory = context.registerService(HttpClientBuilderFactory.class, (Object)new OSGiClientBuilderFactory(configurator, this.httpClientTracker), props);
        props.clear();
        props.put("service.pid", CACHEABLE_BUILDER_FACTORY_SERVICE_PID);
        props.put("service.vendor", (String)context.getBundle().getHeaders().get("Bundle-Vendor"));
        props.put("service.description", CACHEABLE_BUILDER_FACTORY_SERVICE_NAME);
        this.cachingClientFactory = context.registerService(CachingHttpClientBuilderFactory.class, (Object)new OSGiCachingClientBuilderFactory(configurator, this.httpClientTracker), props);
    }

    public void stop(BundleContext context) throws Exception {
        for (ServiceRegistration<ProxyConfiguration> registeredConfiguration : this.registeredConfigurations.values()) {
            HttpProxyConfigurationActivator.safeUnregister(registeredConfiguration);
        }
        this.registeredConfigurations.clear();
        HttpProxyConfigurationActivator.safeUnregister(this.configurator);
        HttpProxyConfigurationActivator.safeUnregister(this.clientFactory);
        HttpProxyConfigurationActivator.safeUnregister(this.cachingClientFactory);
        HttpProxyConfigurationActivator.safeUnregister(this.trustedHostConfiguration);
        this.httpClientTracker.closeAll();
    }

    public String getName() {
        return PROXY_SERVICE_PID;
    }

    public void updated(String pid, Dictionary<String, ?> config) throws ConfigurationException {
        OSGiProxyConfiguration proxyConfiguration;
        ServiceRegistration<ProxyConfiguration> registration = this.registeredConfigurations.get(pid);
        if (registration == null) {
            proxyConfiguration = new OSGiProxyConfiguration();
            ServiceRegistration configurationRegistration = this.context.registerService(ProxyConfiguration.class, (Object)proxyConfiguration, config);
            this.registeredConfigurations.put(pid, (ServiceRegistration<ProxyConfiguration>)configurationRegistration);
            this.proxyConfigurations.add(proxyConfiguration);
        } else {
            proxyConfiguration = (OSGiProxyConfiguration)this.context.getService(registration.getReference());
        }
        proxyConfiguration.update(config);
    }

    public void deleted(String pid) {
        ServiceRegistration<ProxyConfiguration> registration = this.registeredConfigurations.remove(pid);
        if (registration != null) {
            ServiceReference ref = registration.getReference();
            ProxyConfiguration config = (ProxyConfiguration)this.context.getService(ref);
            this.proxyConfigurations.remove(config);
            this.context.ungetService(ref);
            HttpProxyConfigurationActivator.safeUnregister(registration);
        }
    }

    private static <S> boolean safeUnregister(ServiceRegistration<S> serviceRegistration) {
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
            return true;
        }
        return false;
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class HttpClientTracker {
        private final List<CloseableHttpClient> trackedHttpClients = new WeakList<CloseableHttpClient>();

        HttpClientTracker() {
        }

        synchronized void track(CloseableHttpClient client) {
            this.trackedHttpClients.add(client);
        }

        synchronized void closeAll() {
            for (CloseableHttpClient client : this.trackedHttpClients) {
                HttpProxyConfigurationActivator.closeQuietly(client);
            }
            this.trackedHttpClients.clear();
        }
    }
}

