/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.sync;

import java.util.Date;
import org.apache.hc.client5.http.sync.ServiceUnavailableRetryStrategy;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultServiceUnavailableRetryStrategy
implements ServiceUnavailableRetryStrategy {
    private final int maxRetries;
    private final long defaultRetryInterval;

    public DefaultServiceUnavailableRetryStrategy(int maxRetries, int defaultRetryInterval) {
        Args.positive((int)maxRetries, (String)"Max retries");
        Args.positive((int)defaultRetryInterval, (String)"Retry interval");
        this.maxRetries = maxRetries;
        this.defaultRetryInterval = defaultRetryInterval;
    }

    public DefaultServiceUnavailableRetryStrategy() {
        this(1, 1000);
    }

    @Override
    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        return executionCount <= this.maxRetries && response.getCode() == 503;
    }

    @Override
    public long getRetryInterval(HttpResponse response, HttpContext context) {
        block3: {
            Header header = response.getFirstHeader("Retry-After");
            if (header != null) {
                String value = header.getValue();
                try {
                    return Long.parseLong(value) * 1000L;
                }
                catch (NumberFormatException ignore) {
                    Date date = DateUtils.parseDate(value);
                    if (date == null) break block3;
                    long n = date.getTime() - System.currentTimeMillis();
                    return n > 0L ? n : 0L;
                }
            }
        }
        return this.defaultRetryInterval;
    }
}

