/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.nio;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hc.client5.http.ConnectTimeoutException;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.SystemDefaultDnsResolver;
import org.apache.hc.client5.http.UnsupportedSchemeException;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.nio.ManagedAsyncClientConnection;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.ComplexFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.SessionRequest;
import org.apache.hc.core5.reactor.SessionRequestCallback;
import org.apache.hc.core5.reactor.TlsCapableIOSession;
import org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

final class AsyncClientConnectionOperator {
    private final SchemePortResolver schemePortResolver;
    private final DnsResolver dnsResolver;
    private final Lookup<TlsStrategy> tlsStrategyLookup;

    AsyncClientConnectionOperator(SchemePortResolver schemePortResolver, DnsResolver dnsResolver, Lookup<TlsStrategy> tlsStrategyLookup) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
        this.dnsResolver = dnsResolver != null ? dnsResolver : SystemDefaultDnsResolver.INSTANCE;
        this.tlsStrategyLookup = tlsStrategyLookup;
    }

    public Future<ManagedAsyncClientConnection> connect(final ConnectionInitiator connectionInitiator, final HttpHost host, final SocketAddress localAddress, final TimeValue connectTimeout, final Object attachment, FutureCallback<ManagedAsyncClientConnection> callback) {
        int port;
        InetAddress[] remoteAddresses;
        Args.notNull((Object)connectionInitiator, (String)"Connection initiator");
        Args.notNull((Object)host, (String)"Host");
        final ComplexFuture future = new ComplexFuture(callback);
        try {
            remoteAddresses = this.dnsResolver.resolve(host.getHostName());
        }
        catch (UnknownHostException ex) {
            future.failed((Exception)ex);
            return future;
        }
        try {
            port = this.schemePortResolver.resolve(host);
        }
        catch (UnsupportedSchemeException ex) {
            future.failed((Exception)ex);
            return future;
        }
        final TlsStrategy tlsStrategy = this.tlsStrategyLookup != null ? (TlsStrategy)this.tlsStrategyLookup.lookup(host.getSchemeName()) : null;
        Runnable runnable = new Runnable(){
            private final AtomicInteger attempt = new AtomicInteger(0);

            void executeNext() {
                int index = this.attempt.getAndIncrement();
                InetSocketAddress remoteAddress = new InetSocketAddress(remoteAddresses[index], port);
                SessionRequest sessionRequest = connectionInitiator.connect((NamedEndpoint)host, (SocketAddress)remoteAddress, localAddress, attachment, new SessionRequestCallback(){

                    public void completed(SessionRequest request) {
                        TlsCapableIOSession session = request.getSession();
                        ManagedAsyncClientConnection connection = new ManagedAsyncClientConnection(session);
                        if (tlsStrategy != null) {
                            tlsStrategy.upgrade((TransportSecurityLayer)connection, host, session.getLocalAddress(), session.getRemoteAddress(), request.getAttachment());
                        }
                        future.completed((Object)connection);
                    }

                    public void failed(SessionRequest request) {
                        if (attempt.get() >= remoteAddresses.length) {
                            future.failed((Exception)new HttpHostConnectException(request.getException(), host, remoteAddresses));
                        } else {
                            this.executeNext();
                        }
                    }

                    public void timeout(SessionRequest request) {
                        future.failed((Exception)new ConnectTimeoutException(new SocketException(), host, remoteAddresses));
                    }

                    public void cancelled(SessionRequest request) {
                        future.cancel();
                    }
                });
                future.setDependency((Cancellable)sessionRequest);
                sessionRequest.setConnectTimeout(connectTimeout.toMillisIntBound());
            }

            @Override
            public void run() {
                this.executeNext();
            }
        };
        runnable.run();
        return future;
    }

    public void upgrade(ManagedAsyncClientConnection connection, HttpHost host, Object attachment) {
        TlsStrategy tlsStrategy;
        TlsStrategy tlsStrategy2 = tlsStrategy = this.tlsStrategyLookup != null ? (TlsStrategy)this.tlsStrategyLookup.lookup(host.getSchemeName()) : null;
        if (tlsStrategy != null) {
            tlsStrategy.upgrade((TransportSecurityLayer)connection, host, connection.getLocalAddress(), connection.getRemoteAddress(), attachment);
        }
    }
}

