/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache.memcached;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.apache.hc.client5.http.impl.cache.memcached.KeyHashingScheme;
import org.apache.hc.client5.http.impl.cache.memcached.MemcachedKeyHashingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SHA256KeyHashingScheme
implements KeyHashingScheme {
    private final Logger log = LogManager.getLogger(this.getClass());

    @Override
    public String hash(String key) {
        MessageDigest md = this.getDigest();
        md.update(key.getBytes());
        return Hex.encodeHexString(md.digest());
    }

    private MessageDigest getDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException nsae) {
            this.log.error("can't find SHA-256 implementation for cache key hashing");
            throw new MemcachedKeyHashingException(nsae);
        }
    }
}

